/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.NotificationMessageInfo;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageContainerSpec;
import java.util.Optional;

public class NotificationMessageInfoSpec {
    public static byte[] encode(NotificationMessageInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, ChatMessageKeySpec.encode(protoInputObject.key()));
        outputStream.writeBytes(2, MessageContainerSpec.encode(protoInputObject.message()));
        outputStream.writeUInt64(3, Long.valueOf(protoInputObject.messageTimestampSeconds()));
        Optional<String> participant = protoInputObject.participant();
        String participant0 = participant.orElse(null);
        if (participant0 != null) {
            outputStream.writeString(4, participant0);
        }
        return outputStream.toByteArray();
    }

    public static NotificationMessageInfo decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        ChatMessageKey key = null;
        MessageContainer message = null;
        long messageTimestampSeconds = 0L;
        Optional<String> participant = Optional.empty();
        block6: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    key = ChatMessageKeySpec.decode(inputStream.readBytes());
                    continue block6;
                }
                case 2: {
                    message = MessageContainerSpec.decode(inputStream.readBytes());
                    continue block6;
                }
                case 3: {
                    messageTimestampSeconds = inputStream.readInt64();
                    continue block6;
                }
                case 4: {
                    participant = Optional.ofNullable(inputStream.readString());
                    continue block6;
                }
            }
            inputStream.skipBytes();
        }
        return new NotificationMessageInfo(key, message, messageTimestampSeconds, participant);
    }
}

