/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.jid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.whatsapp.model.jid.Jid;
import java.util.Arrays;

public enum JidServer {
    USER("c.us"),
    GROUP("g.us"),
    BROADCAST("broadcast"),
    GROUP_CALL("call"),
    WHATSAPP("s.whatsapp.net"),
    LID("lid"),
    NEWSLETTER("newsletter");

    private final String address;

    private JidServer(String address) {
        this.address = address;
    }

    @JsonCreator
    public static JidServer of(String address) {
        return Arrays.stream(JidServer.values()).filter(entry -> address != null && address.endsWith(entry.address())).findFirst().orElse(WHATSAPP);
    }

    public String address() {
        return this.address;
    }

    public Jid toJid() {
        return Jid.ofServer(this);
    }

    @JsonValue
    public String toString() {
        return this.address();
    }
}

