/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.button.base.Button;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeaderText;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ButtonsMessageBuilder {
    private Optional<ButtonsMessageHeaderText> headerText = Optional.empty();
    private Optional<DocumentMessage> headerDocument = Optional.empty();
    private Optional<ImageMessage> headerImage = Optional.empty();
    private Optional<VideoOrGifMessage> headerVideo = Optional.empty();
    private Optional<LocationMessage> headerLocation = Optional.empty();
    private Optional<String> body = Optional.empty();
    private Optional<String> footer = Optional.empty();
    private Optional<ContextInfo> contextInfo = Optional.empty();
    private List<Button> buttons = new ArrayList<Button>();
    private ButtonsMessageHeader.Type headerType = null;

    public ButtonsMessageBuilder headerText(Optional<ButtonsMessageHeaderText> headerText) {
        this.headerText = headerText;
        return this;
    }

    public ButtonsMessageBuilder headerText(ButtonsMessageHeaderText headerText) {
        this.headerText = Optional.ofNullable(headerText);
        return this;
    }

    public ButtonsMessageBuilder headerDocument(Optional<DocumentMessage> headerDocument) {
        this.headerDocument = headerDocument;
        return this;
    }

    public ButtonsMessageBuilder headerDocument(DocumentMessage headerDocument) {
        this.headerDocument = Optional.ofNullable(headerDocument);
        return this;
    }

    public ButtonsMessageBuilder headerImage(Optional<ImageMessage> headerImage) {
        this.headerImage = headerImage;
        return this;
    }

    public ButtonsMessageBuilder headerImage(ImageMessage headerImage) {
        this.headerImage = Optional.ofNullable(headerImage);
        return this;
    }

    public ButtonsMessageBuilder headerVideo(Optional<VideoOrGifMessage> headerVideo) {
        this.headerVideo = headerVideo;
        return this;
    }

    public ButtonsMessageBuilder headerVideo(VideoOrGifMessage headerVideo) {
        this.headerVideo = Optional.ofNullable(headerVideo);
        return this;
    }

    public ButtonsMessageBuilder headerLocation(Optional<LocationMessage> headerLocation) {
        this.headerLocation = headerLocation;
        return this;
    }

    public ButtonsMessageBuilder headerLocation(LocationMessage headerLocation) {
        this.headerLocation = Optional.ofNullable(headerLocation);
        return this;
    }

    public ButtonsMessageBuilder body(Optional<String> body) {
        this.body = body;
        return this;
    }

    public ButtonsMessageBuilder body(String body) {
        this.body = Optional.ofNullable(body);
        return this;
    }

    public ButtonsMessageBuilder footer(Optional<String> footer) {
        this.footer = footer;
        return this;
    }

    public ButtonsMessageBuilder footer(String footer) {
        this.footer = Optional.ofNullable(footer);
        return this;
    }

    public ButtonsMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ButtonsMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public ButtonsMessageBuilder buttons(List<Button> buttons) {
        this.buttons = buttons;
        return this;
    }

    public ButtonsMessageBuilder headerType(ButtonsMessageHeader.Type headerType) {
        this.headerType = headerType;
        return this;
    }

    public ButtonsMessage build() {
        return new ButtonsMessage(this.headerText, this.headerDocument, this.headerImage, this.headerVideo, this.headerLocation, this.body, this.footer, this.contextInfo, this.buttons, this.headerType);
    }
}

