/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.button.interactive.InteractiveBody;
import it.auties.whatsapp.model.button.interactive.InteractiveCollection;
import it.auties.whatsapp.model.button.interactive.InteractiveFooter;
import it.auties.whatsapp.model.button.interactive.InteractiveHeader;
import it.auties.whatsapp.model.button.interactive.InteractiveNativeFlow;
import it.auties.whatsapp.model.button.interactive.InteractiveShop;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.button.InteractiveMessage;
import java.util.Optional;

public class InteractiveMessageBuilder {
    private Optional<InteractiveHeader> header = Optional.empty();
    private Optional<InteractiveBody> body = Optional.empty();
    private Optional<InteractiveFooter> footer = Optional.empty();
    private Optional<InteractiveShop> contentShop = Optional.empty();
    private Optional<InteractiveCollection> contentCollection = Optional.empty();
    private Optional<InteractiveNativeFlow> contentNativeFlow = Optional.empty();
    private Optional<ContextInfo> contextInfo = Optional.empty();

    public InteractiveMessageBuilder header(Optional<InteractiveHeader> header) {
        this.header = header;
        return this;
    }

    public InteractiveMessageBuilder header(InteractiveHeader header) {
        this.header = Optional.ofNullable(header);
        return this;
    }

    public InteractiveMessageBuilder body(Optional<InteractiveBody> body) {
        this.body = body;
        return this;
    }

    public InteractiveMessageBuilder body(InteractiveBody body) {
        this.body = Optional.ofNullable(body);
        return this;
    }

    public InteractiveMessageBuilder footer(Optional<InteractiveFooter> footer) {
        this.footer = footer;
        return this;
    }

    public InteractiveMessageBuilder footer(InteractiveFooter footer) {
        this.footer = Optional.ofNullable(footer);
        return this;
    }

    public InteractiveMessageBuilder contentShop(Optional<InteractiveShop> contentShop) {
        this.contentShop = contentShop;
        return this;
    }

    public InteractiveMessageBuilder contentShop(InteractiveShop contentShop) {
        this.contentShop = Optional.ofNullable(contentShop);
        return this;
    }

    public InteractiveMessageBuilder contentCollection(Optional<InteractiveCollection> contentCollection) {
        this.contentCollection = contentCollection;
        return this;
    }

    public InteractiveMessageBuilder contentCollection(InteractiveCollection contentCollection) {
        this.contentCollection = Optional.ofNullable(contentCollection);
        return this;
    }

    public InteractiveMessageBuilder contentNativeFlow(Optional<InteractiveNativeFlow> contentNativeFlow) {
        this.contentNativeFlow = contentNativeFlow;
        return this;
    }

    public InteractiveMessageBuilder contentNativeFlow(InteractiveNativeFlow contentNativeFlow) {
        this.contentNativeFlow = Optional.ofNullable(contentNativeFlow);
        return this;
    }

    public InteractiveMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public InteractiveMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public InteractiveMessage build() {
        return new InteractiveMessage(this.header, this.body, this.footer, this.contentShop, this.contentCollection, this.contentNativeFlow, this.contextInfo);
    }
}

