/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.button.misc.ButtonSection;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ProductListInfo;
import it.auties.whatsapp.model.message.button.ListMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ListMessageBuilder {
    private String title = null;
    private Optional<String> description = Optional.empty();
    private String button = null;
    private ListMessage.Type listType = null;
    private List<ButtonSection> sections = new ArrayList<ButtonSection>();
    private Optional<ProductListInfo> productListInfo = Optional.empty();
    private Optional<String> footer = Optional.empty();
    private Optional<ContextInfo> contextInfo = Optional.empty();

    public ListMessageBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ListMessageBuilder description(Optional<String> description) {
        this.description = description;
        return this;
    }

    public ListMessageBuilder description(String description) {
        this.description = Optional.ofNullable(description);
        return this;
    }

    public ListMessageBuilder button(String button) {
        this.button = button;
        return this;
    }

    public ListMessageBuilder listType(ListMessage.Type listType) {
        this.listType = listType;
        return this;
    }

    public ListMessageBuilder sections(List<ButtonSection> sections) {
        this.sections = sections;
        return this;
    }

    public ListMessageBuilder productListInfo(Optional<ProductListInfo> productListInfo) {
        this.productListInfo = productListInfo;
        return this;
    }

    public ListMessageBuilder productListInfo(ProductListInfo productListInfo) {
        this.productListInfo = Optional.ofNullable(productListInfo);
        return this;
    }

    public ListMessageBuilder footer(Optional<String> footer) {
        this.footer = footer;
        return this;
    }

    public ListMessageBuilder footer(String footer) {
        this.footer = Optional.ofNullable(footer);
        return this;
    }

    public ListMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ListMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public ListMessage build() {
        return new ListMessage(this.title, this.description, this.button, this.listType, this.sections, this.productListInfo, this.footer, this.contextInfo);
    }
}

