/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.button.misc.SingleSelectReplyButton;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.button.ListResponseMessage;
import java.util.Optional;

public class ListResponseMessageBuilder {
    private String title = null;
    private SingleSelectReplyButton reply = null;
    private Optional<ContextInfo> contextInfo = Optional.empty();
    private Optional<String> description = Optional.empty();
    private ListResponseMessage.Type listType = null;

    public ListResponseMessageBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ListResponseMessageBuilder reply(SingleSelectReplyButton reply) {
        this.reply = reply;
        return this;
    }

    public ListResponseMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ListResponseMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public ListResponseMessageBuilder description(Optional<String> description) {
        this.description = description;
        return this;
    }

    public ListResponseMessageBuilder description(String description) {
        this.description = Optional.ofNullable(description);
        return this;
    }

    public ListResponseMessageBuilder listType(ListResponseMessage.Type listType) {
        this.listType = listType;
        return this;
    }

    public ListResponseMessage build() {
        return new ListResponseMessage(this.title, this.reply, this.contextInfo, this.description, this.listType);
    }
}

