/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.model.KeepInChat;
import it.auties.whatsapp.model.message.model.KeepInChatType;
import it.auties.whatsapp.model.message.model.KeepInChatTypeSpec;

public class KeepInChatSpec {
    public static byte[] encode(KeepInChat protoInputObject) {
        String deviceJid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeInt32(1, KeepInChatTypeSpec.encode(protoInputObject.keepType()));
        outputStream.writeInt64(2, Long.valueOf(protoInputObject.serverTimestampSeconds()));
        outputStream.writeBytes(3, ChatMessageKeySpec.encode(protoInputObject.key()));
        Jid deviceJid = protoInputObject.deviceJid();
        if (deviceJid != null && (deviceJid0 = deviceJid.toProtobufValue()) != null) {
            outputStream.writeString(4, deviceJid0);
        }
        outputStream.writeInt64(5, Long.valueOf(protoInputObject.clientTimestampInMilliseconds()));
        outputStream.writeInt64(6, Long.valueOf(protoInputObject.serverTimestampMilliseconds()));
        return outputStream.toByteArray();
    }

    public static KeepInChat decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        KeepInChatType keepType = null;
        long serverTimestampSeconds = 0L;
        ChatMessageKey key = null;
        Jid deviceJid = null;
        long clientTimestampInMilliseconds = 0L;
        long serverTimestampMilliseconds = 0L;
        block8: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    keepType = KeepInChatTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block8;
                }
                case 2: {
                    serverTimestampSeconds = inputStream.readInt64();
                    continue block8;
                }
                case 3: {
                    key = ChatMessageKeySpec.decode(inputStream.readBytes());
                    continue block8;
                }
                case 4: {
                    deviceJid = Jid.ofProtobuf(inputStream.readString());
                    continue block8;
                }
                case 5: {
                    clientTimestampInMilliseconds = inputStream.readInt64();
                    continue block8;
                }
                case 6: {
                    serverTimestampMilliseconds = inputStream.readInt64();
                    continue block8;
                }
            }
            inputStream.skipBytes();
        }
        return new KeepInChat(keepType, serverTimestampSeconds, key, deviceJid, clientTimestampInMilliseconds, serverTimestampMilliseconds);
    }
}

