/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MutableAttachmentProvider;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.model.reserved.ExtendedMediaMessage;
import it.auties.whatsapp.model.message.payment.PaymentInvoiceMessage;
import it.auties.whatsapp.model.message.standard.AudioMessage;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.StickerMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.OptionalLong;

public sealed interface MediaMessage<T extends MediaMessage<T>>
extends ContextualMessage,
MutableAttachmentProvider<T>
permits ExtendedMediaMessage, PaymentInvoiceMessage, AudioMessage, DocumentMessage, ImageMessage, StickerMessage, VideoOrGifMessage {
    public OptionalLong mediaKeyTimestampSeconds();

    public Optional<ZonedDateTime> mediaKeyTimestamp();

    public MediaMessageType mediaType();

    @Override
    default public MessageCategory category() {
        return MessageCategory.MEDIA;
    }

    @Override
    default public MessageType type() {
        return this.mediaType().toMessageType();
    }

    @Override
    default public AttachmentType attachmentType() {
        return this.mediaType().toAttachmentType();
    }
}

