/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

@ProtobufMessageName(value="UserReceipt")
public final class MessageReceipt
implements ProtobufMessage {
    @ProtobufProperty(index=2, type=ProtobufType.INT64)
    private Long deliveredTimestampSeconds;
    @ProtobufProperty(index=3, type=ProtobufType.INT64)
    private Long readTimestampSeconds;
    @ProtobufProperty(index=4, type=ProtobufType.INT64)
    private Long playedTimestampSeconds;
    @ProtobufProperty(index=5, type=ProtobufType.STRING, repeated=true)
    private final Set<Jid> deliveredJids;
    @ProtobufProperty(index=6, type=ProtobufType.STRING, repeated=true)
    private final Set<Jid> readJids;

    public MessageReceipt() {
        this.deliveredJids = new HashSet<Jid>();
        this.readJids = new HashSet<Jid>();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public MessageReceipt(Long deliveredTimestampSeconds, Long readTimestampSeconds, Long playedTimestampSeconds, Set<Jid> deliveredJids, Set<Jid> readJids) {
        this.deliveredTimestampSeconds = deliveredTimestampSeconds;
        this.readTimestampSeconds = readTimestampSeconds;
        this.playedTimestampSeconds = playedTimestampSeconds;
        this.deliveredJids = deliveredJids;
        this.readJids = readJids;
    }

    public OptionalLong deliveredTimestampSeconds() {
        return Clock.parseTimestamp(this.deliveredTimestampSeconds);
    }

    public Optional<ZonedDateTime> deliveredTimestamp() {
        return Clock.parseSeconds(this.deliveredTimestampSeconds);
    }

    public OptionalLong readTimestampSeconds() {
        return Clock.parseTimestamp(this.readTimestampSeconds);
    }

    public Optional<ZonedDateTime> readTimestamp() {
        return Clock.parseSeconds(this.readTimestampSeconds);
    }

    public OptionalLong playedTimestampSeconds() {
        return Clock.parseTimestamp(this.playedTimestampSeconds);
    }

    public Optional<ZonedDateTime> playedTimestamp() {
        return Clock.parseSeconds(this.playedTimestampSeconds);
    }

    public Set<Jid> deliveredJids() {
        return this.deliveredJids;
    }

    public Set<Jid> readJids() {
        return this.readJids;
    }

    public MessageReceipt readTimestampSeconds(long readTimestampSeconds) {
        if (this.deliveredTimestampSeconds == null) {
            this.deliveredTimestampSeconds = readTimestampSeconds;
        }
        this.readTimestampSeconds = readTimestampSeconds;
        return this;
    }

    public MessageReceipt playedTimestampSeconds(long playedTimestampSeconds) {
        if (this.deliveredTimestampSeconds == null) {
            this.deliveredTimestampSeconds = playedTimestampSeconds;
        }
        if (this.readTimestampSeconds == null) {
            this.readTimestampSeconds = playedTimestampSeconds;
        }
        this.playedTimestampSeconds = playedTimestampSeconds;
        return this;
    }
}

