/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.payment.PaymentOrderMessage;
import java.util.Optional;

public class PaymentOrderMessageBuilder {
    private String id = null;
    private Optional<byte[]> thumbnail = Optional.empty();
    private int itemCount = 0;
    private PaymentOrderMessage.Status status = null;
    private PaymentOrderMessage.PaymentOrderSurface surface = null;
    private Optional<String> message = Optional.empty();
    private Optional<String> title = Optional.empty();
    private Jid sellerId = null;
    private String token = null;
    private long amount = 0L;
    private String currency = null;
    private Optional<ContextInfo> contextInfo = Optional.empty();

    public PaymentOrderMessageBuilder id(String id) {
        this.id = id;
        return this;
    }

    public PaymentOrderMessageBuilder thumbnail(Optional<byte[]> thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public PaymentOrderMessageBuilder thumbnail(byte[] thumbnail) {
        this.thumbnail = Optional.ofNullable(thumbnail);
        return this;
    }

    public PaymentOrderMessageBuilder itemCount(int itemCount) {
        this.itemCount = itemCount;
        return this;
    }

    public PaymentOrderMessageBuilder status(PaymentOrderMessage.Status status) {
        this.status = status;
        return this;
    }

    public PaymentOrderMessageBuilder surface(PaymentOrderMessage.PaymentOrderSurface surface) {
        this.surface = surface;
        return this;
    }

    public PaymentOrderMessageBuilder message(Optional<String> message) {
        this.message = message;
        return this;
    }

    public PaymentOrderMessageBuilder message(String message) {
        this.message = Optional.ofNullable(message);
        return this;
    }

    public PaymentOrderMessageBuilder title(Optional<String> title) {
        this.title = title;
        return this;
    }

    public PaymentOrderMessageBuilder title(String title) {
        this.title = Optional.ofNullable(title);
        return this;
    }

    public PaymentOrderMessageBuilder sellerId(Jid sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    public PaymentOrderMessageBuilder token(String token) {
        this.token = token;
        return this;
    }

    public PaymentOrderMessageBuilder amount(long amount) {
        this.amount = amount;
        return this;
    }

    public PaymentOrderMessageBuilder currency(String currency) {
        this.currency = currency;
        return this;
    }

    public PaymentOrderMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public PaymentOrderMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public PaymentOrderMessage build() {
        return new PaymentOrderMessage(this.id, this.thumbnail, this.itemCount, this.status, this.surface, this.message, this.title, this.sellerId, this.token, this.amount, this.currency, this.contextInfo);
    }
}

