/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.payment;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.payment.PaymentOrderMessage;
import it.auties.whatsapp.model.message.payment.PaymentOrderMessagePaymentOrderSurfaceSpec;
import it.auties.whatsapp.model.message.payment.PaymentOrderMessageStatusSpec;
import java.util.Optional;

public class PaymentOrderMessageSpec {
    public static byte[] encode(PaymentOrderMessage protoInputObject) {
        String sellerId0;
        Jid sellerId;
        Optional<String> title;
        String title0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeString(1, protoInputObject.id());
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        byte[] thumbnail0 = thumbnail.orElse(null);
        if (thumbnail0 != null) {
            outputStream.writeBytes(2, thumbnail0);
        }
        outputStream.writeUInt32(3, Integer.valueOf(protoInputObject.itemCount()));
        outputStream.writeInt32(4, PaymentOrderMessageStatusSpec.encode(protoInputObject.status()));
        outputStream.writeInt32(5, PaymentOrderMessagePaymentOrderSurfaceSpec.encode(protoInputObject.surface()));
        Optional<String> message = protoInputObject.message();
        String message0 = message.orElse(null);
        if (message0 != null) {
            outputStream.writeString(6, message0);
        }
        if ((title0 = (String)(title = protoInputObject.title()).orElse(null)) != null) {
            outputStream.writeString(7, title0);
        }
        if ((sellerId = protoInputObject.sellerId()) != null && (sellerId0 = sellerId.toProtobufValue()) != null) {
            outputStream.writeString(8, sellerId0);
        }
        outputStream.writeString(9, protoInputObject.token());
        outputStream.writeUInt64(10, Long.valueOf(protoInputObject.amount()));
        outputStream.writeString(11, protoInputObject.currency());
        Optional<ContextInfo> contextInfo = protoInputObject.contextInfo();
        ContextInfo contextInfo0 = contextInfo.orElse(null);
        if (contextInfo0 != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static PaymentOrderMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String id = null;
        Optional<byte[]> thumbnail = Optional.empty();
        int itemCount = 0;
        PaymentOrderMessage.Status status = null;
        PaymentOrderMessage.PaymentOrderSurface surface = null;
        Optional<String> message = Optional.empty();
        Optional<String> title = Optional.empty();
        Jid sellerId = null;
        String token = null;
        long amount = 0L;
        String currency = null;
        Optional<ContextInfo> contextInfo = Optional.empty();
        block14: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    id = inputStream.readString();
                    continue block14;
                }
                case 2: {
                    thumbnail = Optional.ofNullable(inputStream.readBytes());
                    continue block14;
                }
                case 3: {
                    itemCount = inputStream.readInt32();
                    continue block14;
                }
                case 4: {
                    status = PaymentOrderMessageStatusSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block14;
                }
                case 5: {
                    surface = PaymentOrderMessagePaymentOrderSurfaceSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block14;
                }
                case 6: {
                    message = Optional.ofNullable(inputStream.readString());
                    continue block14;
                }
                case 7: {
                    title = Optional.ofNullable(inputStream.readString());
                    continue block14;
                }
                case 8: {
                    sellerId = Jid.ofProtobuf(inputStream.readString());
                    continue block14;
                }
                case 9: {
                    token = inputStream.readString();
                    continue block14;
                }
                case 10: {
                    amount = inputStream.readInt64();
                    continue block14;
                }
                case 11: {
                    currency = inputStream.readString();
                    continue block14;
                }
                case 17: {
                    contextInfo = Optional.ofNullable(ContextInfoSpec.decode(inputStream.readBytes()));
                    continue block14;
                }
            }
            inputStream.skipBytes();
        }
        return new PaymentOrderMessage(id, thumbnail, itemCount, status, surface, message, title, sellerId, token, amount, currency, contextInfo);
    }
}

