/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.standard.GroupInviteMessage;
import it.auties.whatsapp.model.message.standard.GroupInviteMessageTypeSpec;
import java.util.Optional;

public class GroupInviteMessageSpec {
    public static byte[] encode(GroupInviteMessage protoInputObject) {
        Optional<ContextInfo> contextInfo;
        ContextInfo contextInfo0;
        Optional<String> caption;
        String caption0;
        String group0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid group = protoInputObject.group();
        if (group != null && (group0 = group.toProtobufValue()) != null) {
            outputStream.writeString(1, group0);
        }
        outputStream.writeString(2, protoInputObject.code());
        outputStream.writeUInt64(3, Long.valueOf(protoInputObject.expirationSeconds()));
        outputStream.writeString(4, protoInputObject.groupName());
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        byte[] thumbnail0 = thumbnail.orElse(null);
        if (thumbnail0 != null) {
            outputStream.writeBytes(5, thumbnail0);
        }
        if ((caption0 = (String)(caption = protoInputObject.caption()).orElse(null)) != null) {
            outputStream.writeString(6, caption0);
        }
        if ((contextInfo0 = (ContextInfo)(contextInfo = protoInputObject.contextInfo()).orElse(null)) != null) {
            outputStream.writeBytes(7, ContextInfoSpec.encode(contextInfo0));
        }
        outputStream.writeInt32(8, GroupInviteMessageTypeSpec.encode(protoInputObject.groupType()));
        return outputStream.toByteArray();
    }

    public static GroupInviteMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid group = null;
        String code = null;
        long expirationSeconds = 0L;
        String groupName = null;
        Optional<byte[]> thumbnail = Optional.empty();
        Optional<String> caption = Optional.empty();
        Optional<ContextInfo> contextInfo = Optional.empty();
        GroupInviteMessage.Type groupType = null;
        block10: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    group = Jid.ofProtobuf(inputStream.readString());
                    continue block10;
                }
                case 2: {
                    code = inputStream.readString();
                    continue block10;
                }
                case 3: {
                    expirationSeconds = inputStream.readInt64();
                    continue block10;
                }
                case 4: {
                    groupName = inputStream.readString();
                    continue block10;
                }
                case 5: {
                    thumbnail = Optional.ofNullable(inputStream.readBytes());
                    continue block10;
                }
                case 6: {
                    caption = Optional.ofNullable(inputStream.readString());
                    continue block10;
                }
                case 7: {
                    contextInfo = Optional.ofNullable(ContextInfoSpec.decode(inputStream.readBytes()));
                    continue block10;
                }
                case 8: {
                    groupType = GroupInviteMessageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block10;
                }
            }
            inputStream.skipBytes();
        }
        return new GroupInviteMessage(group, code, expirationSeconds, groupName, thumbnail, caption, contextInfo, groupType);
    }
}

