/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import java.util.Optional;

public class LiveLocationMessageBuilder {
    private double latitude = 0.0;
    private double longitude = 0.0;
    private int accuracy = 0;
    private float speed = 0.0f;
    private int magneticNorthOffset = 0;
    private Optional<String> caption = Optional.empty();
    private long sequenceNumber = 0L;
    private int timeOffset = 0;
    private Optional<byte[]> thumbnail = Optional.empty();
    private Optional<ContextInfo> contextInfo = Optional.empty();

    public LiveLocationMessageBuilder latitude(double latitude) {
        this.latitude = latitude;
        return this;
    }

    public LiveLocationMessageBuilder longitude(double longitude) {
        this.longitude = longitude;
        return this;
    }

    public LiveLocationMessageBuilder accuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public LiveLocationMessageBuilder speed(float speed) {
        this.speed = speed;
        return this;
    }

    public LiveLocationMessageBuilder magneticNorthOffset(int magneticNorthOffset) {
        this.magneticNorthOffset = magneticNorthOffset;
        return this;
    }

    public LiveLocationMessageBuilder caption(Optional<String> caption) {
        this.caption = caption;
        return this;
    }

    public LiveLocationMessageBuilder caption(String caption) {
        this.caption = Optional.ofNullable(caption);
        return this;
    }

    public LiveLocationMessageBuilder sequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    public LiveLocationMessageBuilder timeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        return this;
    }

    public LiveLocationMessageBuilder thumbnail(Optional<byte[]> thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public LiveLocationMessageBuilder thumbnail(byte[] thumbnail) {
        this.thumbnail = Optional.ofNullable(thumbnail);
        return this;
    }

    public LiveLocationMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public LiveLocationMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public LiveLocationMessage build() {
        return new LiveLocationMessage(this.latitude, this.longitude, this.accuracy, this.speed, this.magneticNorthOffset, this.caption, this.sequenceNumber, this.timeOffset, this.thumbnail, this.contextInfo);
    }
}

