/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import java.util.Optional;

public class LocationMessageBuilder {
    private double latitude = 0.0;
    private double longitude = 0.0;
    private Optional<String> name = Optional.empty();
    private Optional<String> address = Optional.empty();
    private Optional<String> url = Optional.empty();
    private boolean live = false;
    private int accuracy = 0;
    private float speed = 0.0f;
    private int magneticNorthOffset = 0;
    private Optional<String> caption = Optional.empty();
    private Optional<byte[]> thumbnail = Optional.empty();
    private Optional<ContextInfo> contextInfo = Optional.empty();

    public LocationMessageBuilder latitude(double latitude) {
        this.latitude = latitude;
        return this;
    }

    public LocationMessageBuilder longitude(double longitude) {
        this.longitude = longitude;
        return this;
    }

    public LocationMessageBuilder name(Optional<String> name) {
        this.name = name;
        return this;
    }

    public LocationMessageBuilder name(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public LocationMessageBuilder address(Optional<String> address) {
        this.address = address;
        return this;
    }

    public LocationMessageBuilder address(String address) {
        this.address = Optional.ofNullable(address);
        return this;
    }

    public LocationMessageBuilder url(Optional<String> url) {
        this.url = url;
        return this;
    }

    public LocationMessageBuilder url(String url) {
        this.url = Optional.ofNullable(url);
        return this;
    }

    public LocationMessageBuilder live(boolean live) {
        this.live = live;
        return this;
    }

    public LocationMessageBuilder accuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public LocationMessageBuilder speed(float speed) {
        this.speed = speed;
        return this;
    }

    public LocationMessageBuilder magneticNorthOffset(int magneticNorthOffset) {
        this.magneticNorthOffset = magneticNorthOffset;
        return this;
    }

    public LocationMessageBuilder caption(Optional<String> caption) {
        this.caption = caption;
        return this;
    }

    public LocationMessageBuilder caption(String caption) {
        this.caption = Optional.ofNullable(caption);
        return this;
    }

    public LocationMessageBuilder thumbnail(Optional<byte[]> thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public LocationMessageBuilder thumbnail(byte[] thumbnail) {
        this.thumbnail = Optional.ofNullable(thumbnail);
        return this;
    }

    public LocationMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public LocationMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public LocationMessage build() {
        return new LocationMessage(this.latitude, this.longitude, this.name, this.address, this.url, this.live, this.accuracy, this.speed, this.magneticNorthOffset, this.caption, this.thumbnail, this.contextInfo);
    }
}

