/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import java.util.Optional;

public class LocationMessageSpec {
    public static byte[] encode(LocationMessage protoInputObject) {
        Optional<ContextInfo> contextInfo;
        ContextInfo contextInfo0;
        Optional<byte[]> thumbnail;
        byte[] thumbnail0;
        Optional<String> url;
        String url0;
        Optional<String> address;
        String address0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeDouble(1, Double.valueOf(protoInputObject.latitude()));
        outputStream.writeDouble(2, Double.valueOf(protoInputObject.longitude()));
        Optional<String> name = protoInputObject.name();
        String name0 = name.orElse(null);
        if (name0 != null) {
            outputStream.writeString(3, name0);
        }
        if ((address0 = (String)(address = protoInputObject.address()).orElse(null)) != null) {
            outputStream.writeString(4, address0);
        }
        if ((url0 = (String)(url = protoInputObject.url()).orElse(null)) != null) {
            outputStream.writeString(5, url0);
        }
        outputStream.writeBool(6, Boolean.valueOf(protoInputObject.live()));
        outputStream.writeUInt32(7, Integer.valueOf(protoInputObject.accuracy()));
        outputStream.writeFloat(8, Float.valueOf(protoInputObject.speed()));
        outputStream.writeUInt32(9, Integer.valueOf(protoInputObject.magneticNorthOffset()));
        Optional<String> caption = protoInputObject.caption();
        String caption0 = caption.orElse(null);
        if (caption0 != null) {
            outputStream.writeString(11, caption0);
        }
        if ((thumbnail0 = (byte[])(thumbnail = protoInputObject.thumbnail()).orElse(null)) != null) {
            outputStream.writeBytes(16, thumbnail0);
        }
        if ((contextInfo0 = (ContextInfo)(contextInfo = protoInputObject.contextInfo()).orElse(null)) != null) {
            outputStream.writeBytes(17, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static LocationMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        double latitude = 0.0;
        double longitude = 0.0;
        Optional<String> name = Optional.empty();
        Optional<String> address = Optional.empty();
        Optional<String> url = Optional.empty();
        boolean live = false;
        int accuracy = 0;
        float speed = 0.0f;
        int magneticNorthOffset = 0;
        Optional<String> caption = Optional.empty();
        Optional<byte[]> thumbnail = Optional.empty();
        Optional<ContextInfo> contextInfo = Optional.empty();
        block14: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    latitude = inputStream.readDouble();
                    continue block14;
                }
                case 2: {
                    longitude = inputStream.readDouble();
                    continue block14;
                }
                case 3: {
                    name = Optional.ofNullable(inputStream.readString());
                    continue block14;
                }
                case 4: {
                    address = Optional.ofNullable(inputStream.readString());
                    continue block14;
                }
                case 5: {
                    url = Optional.ofNullable(inputStream.readString());
                    continue block14;
                }
                case 6: {
                    live = inputStream.readBool();
                    continue block14;
                }
                case 7: {
                    accuracy = inputStream.readInt32();
                    continue block14;
                }
                case 8: {
                    speed = inputStream.readFloat();
                    continue block14;
                }
                case 9: {
                    magneticNorthOffset = inputStream.readInt32();
                    continue block14;
                }
                case 11: {
                    caption = Optional.ofNullable(inputStream.readString());
                    continue block14;
                }
                case 16: {
                    thumbnail = Optional.ofNullable(inputStream.readBytes());
                    continue block14;
                }
                case 17: {
                    contextInfo = Optional.ofNullable(ContextInfoSpec.decode(inputStream.readBytes()));
                    continue block14;
                }
            }
            inputStream.skipBytes();
        }
        return new LocationMessage(latitude, longitude, name, address, url, live, accuracy, speed, magneticNorthOffset, caption, thumbnail, contextInfo);
    }
}

