/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufBuilder;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.standard.PollCreationMessageBuilder;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.Validate;
import java.util.Collection;
import java.util.Collections;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@ProtobufMessageName(value="Message.PollCreationMessage")
public final class PollCreationMessage
implements ContextualMessage {
    @ProtobufProperty(index=1, type=ProtobufType.BYTES)
    private byte[] encryptionKey;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private final String title;
    @ProtobufProperty(index=3, type=ProtobufType.OBJECT, repeated=true)
    private final List<PollOption> selectableOptions;
    @ProtobufProperty(index=4, type=ProtobufType.UINT32)
    private final int selectableOptionsCount;
    @ProtobufProperty(index=5, type=ProtobufType.OBJECT)
    private final ContextInfo contextInfo;
    private final Map<String, PollOption> selectableOptionsMap;
    private final Map<Jid, Collection<PollOption>> selectedOptionsMap;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PollCreationMessage(byte[] encryptionKey, String title, List<PollOption> selectableOptions, int selectableOptionsCount, ContextInfo contextInfo, Map<String, PollOption> selectableOptionsMap, Map<Jid, Collection<PollOption>> selectedOptionsMap) {
        this.encryptionKey = encryptionKey;
        this.title = title;
        this.selectableOptions = selectableOptions;
        this.selectableOptionsCount = selectableOptionsCount;
        this.contextInfo = contextInfo;
        this.selectableOptionsMap = selectableOptionsMap;
        this.selectedOptionsMap = selectedOptionsMap;
    }

    public PollCreationMessage(byte[] encryptionKey, String title, List<PollOption> selectableOptions, int selectableOptionsCount, ContextInfo contextInfo) {
        this.encryptionKey = encryptionKey;
        this.title = title;
        this.selectableOptions = selectableOptions;
        this.selectableOptionsCount = selectableOptionsCount;
        this.contextInfo = contextInfo;
        this.selectedOptionsMap = new ConcurrentHashMap<Jid, Collection<PollOption>>();
        this.selectableOptionsMap = new ConcurrentHashMap<String, PollOption>();
    }

    @ProtobufBuilder(className="PollCreationMessageSimpleBuilder")
    static PollCreationMessage simpleBuilder(String title, List<PollOption> selectableOptions) {
        Validate.isTrue(!title.isBlank(), "Title cannot be empty", new Object[0]);
        Validate.isTrue(selectableOptions.size() > 1, "Options must have at least two entries", new Object[0]);
        PollCreationMessage result = new PollCreationMessageBuilder().encryptionKey(KeyHelper.senderKey()).title(title).selectableOptions(selectableOptions).selectableOptionsCount(selectableOptions.size()).build();
        for (PollOption entry : result.selectableOptions()) {
            String sha256 = HexFormat.of().formatHex(Sha256.calculate(entry.name()));
            result.addSelectableOption(sha256, entry);
        }
        return result;
    }

    public Collection<PollOption> getSelectedOptions(JidProvider voter) {
        Collection<PollOption> results = this.selectedOptionsMap.get(voter.toJid());
        if (results == null) {
            return List.of();
        }
        return Collections.unmodifiableCollection(results);
    }

    public void addSelectedOptions(JidProvider voter, Collection<PollOption> voted) {
        this.selectedOptionsMap.put(voter.toJid(), voted);
    }

    public void addSelectableOption(String hash, PollOption option) {
        this.selectableOptionsMap.put(hash, option);
    }

    public Optional<PollOption> getSelectableOption(String hash) {
        return Optional.ofNullable(this.selectableOptionsMap.get(hash));
    }

    @Override
    public MessageType type() {
        return MessageType.POLL_CREATION;
    }

    @Override
    public MessageCategory category() {
        return MessageCategory.STANDARD;
    }

    public String title() {
        return this.title;
    }

    public List<PollOption> selectableOptions() {
        return this.selectableOptions;
    }

    public int selectableOptionsCount() {
        return this.selectableOptionsCount;
    }

    public Optional<byte[]> encryptionKey() {
        return Optional.ofNullable(this.encryptionKey);
    }

    public void setEncryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    public Optional<ContextInfo> contextInfo() {
        return Optional.ofNullable(this.contextInfo);
    }
}

