/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.model.poll.PollOptionSpec;
import java.util.ArrayList;
import java.util.Optional;

public class PollCreationMessageSpec {
    public static byte[] encode(PollCreationMessage protoInputObject) {
        ContextInfo contextInfo0;
        Object encryptionKey0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Optional<byte[]> encryptionKey = protoInputObject.encryptionKey();
        if (encryptionKey != null && (encryptionKey0 = (byte[])encryptionKey.orElse(null)) != null) {
            outputStream.writeBytes(1, (byte[])encryptionKey0);
        }
        outputStream.writeString(2, protoInputObject.title());
        if (protoInputObject.selectableOptions() != null) {
            encryptionKey0 = protoInputObject.selectableOptions().iterator();
            while (encryptionKey0.hasNext()) {
                PollOption selectableOptionsEntry = (PollOption)encryptionKey0.next();
                outputStream.writeBytes(3, PollOptionSpec.encode(selectableOptionsEntry));
            }
        }
        outputStream.writeUInt32(4, Integer.valueOf(protoInputObject.selectableOptionsCount()));
        Optional<ContextInfo> contextInfo = protoInputObject.contextInfo();
        if (contextInfo != null && (contextInfo0 = (ContextInfo)contextInfo.orElse(null)) != null) {
            outputStream.writeBytes(5, ContextInfoSpec.encode(contextInfo0));
        }
        return outputStream.toByteArray();
    }

    public static PollCreationMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        byte[] encryptionKey = null;
        String title = null;
        ArrayList<PollOption> selectableOptions = new ArrayList<PollOption>();
        int selectableOptionsCount = 0;
        ContextInfo contextInfo = null;
        block7: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    encryptionKey = inputStream.readBytes();
                    continue block7;
                }
                case 2: {
                    title = inputStream.readString();
                    continue block7;
                }
                case 3: {
                    selectableOptions.add(PollOptionSpec.decode(inputStream.readBytes()));
                    continue block7;
                }
                case 4: {
                    selectableOptionsCount = inputStream.readInt32();
                    continue block7;
                }
                case 5: {
                    contextInfo = ContextInfoSpec.decode(inputStream.readBytes());
                    continue block7;
                }
            }
            inputStream.skipBytes();
        }
        return new PollCreationMessage(encryptionKey, title, selectableOptions, selectableOptionsCount, contextInfo);
    }
}

