/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.standard.PollUpdateMessage;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadataSpec;
import it.auties.whatsapp.model.poll.PollUpdateMessageMetadata;
import it.auties.whatsapp.model.poll.PollUpdateMessageMetadataSpec;
import java.util.Optional;

public class PollUpdateMessageSpec {
    public static byte[] encode(PollUpdateMessage protoInputObject) {
        PollUpdateMessageMetadata metadata0;
        Optional<PollUpdateMessageMetadata> metadata;
        PollUpdateEncryptedMetadata encryptedMetadata0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, ChatMessageKeySpec.encode(protoInputObject.pollCreationMessageKey()));
        Optional<PollUpdateEncryptedMetadata> encryptedMetadata = protoInputObject.encryptedMetadata();
        if (encryptedMetadata != null && (encryptedMetadata0 = (PollUpdateEncryptedMetadata)encryptedMetadata.orElse(null)) != null) {
            outputStream.writeBytes(2, PollUpdateEncryptedMetadataSpec.encode(encryptedMetadata0));
        }
        if ((metadata = protoInputObject.metadata()) != null && (metadata0 = (PollUpdateMessageMetadata)metadata.orElse(null)) != null) {
            outputStream.writeBytes(3, PollUpdateMessageMetadataSpec.encode(metadata0));
        }
        outputStream.writeInt64(4, Long.valueOf(protoInputObject.senderTimestampMilliseconds()));
        return outputStream.toByteArray();
    }

    public static PollUpdateMessage decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        ChatMessageKey pollCreationMessageKey = null;
        PollUpdateEncryptedMetadata encryptedMetadata = null;
        PollUpdateMessageMetadata metadata = null;
        long senderTimestampMilliseconds = 0L;
        block6: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    pollCreationMessageKey = ChatMessageKeySpec.decode(inputStream.readBytes());
                    continue block6;
                }
                case 2: {
                    encryptedMetadata = PollUpdateEncryptedMetadataSpec.decode(inputStream.readBytes());
                    continue block6;
                }
                case 3: {
                    metadata = PollUpdateMessageMetadataSpec.decode(inputStream.readBytes());
                    continue block6;
                }
                case 4: {
                    senderTimestampMilliseconds = inputStream.readInt64();
                    continue block6;
                }
            }
            inputStream.skipBytes();
        }
        return new PollUpdateMessage(pollCreationMessageKey, encryptedMetadata, metadata, senderTimestampMilliseconds);
    }
}

