/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.standard.ProductMessage;
import it.auties.whatsapp.model.product.Product;
import it.auties.whatsapp.model.product.ProductCatalog;
import java.util.Optional;

public class ProductMessageBuilder {
    private Product product = null;
    private Jid businessOwnerJid = null;
    private ProductCatalog catalog = null;
    private Optional<String> body = Optional.empty();
    private Optional<String> footer = Optional.empty();
    private Optional<ContextInfo> contextInfo = Optional.empty();

    public ProductMessageBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public ProductMessageBuilder businessOwnerJid(Jid businessOwnerJid) {
        this.businessOwnerJid = businessOwnerJid;
        return this;
    }

    public ProductMessageBuilder catalog(ProductCatalog catalog) {
        this.catalog = catalog;
        return this;
    }

    public ProductMessageBuilder body(Optional<String> body) {
        this.body = body;
        return this;
    }

    public ProductMessageBuilder body(String body) {
        this.body = Optional.ofNullable(body);
        return this;
    }

    public ProductMessageBuilder footer(Optional<String> footer) {
        this.footer = footer;
        return this;
    }

    public ProductMessageBuilder footer(String footer) {
        this.footer = Optional.ofNullable(footer);
        return this;
    }

    public ProductMessageBuilder contextInfo(Optional<ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ProductMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = Optional.ofNullable(contextInfo);
        return this;
    }

    public ProductMessage build() {
        return new ProductMessage(this.product, this.businessOwnerJid, this.catalog, this.body, this.footer, this.contextInfo);
    }
}

