/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.standard.TextMessage;

public class TextMessageBuilder {
    private String text = null;
    private String matchedText = null;
    private String canonicalUrl = null;
    private String description = null;
    private String title = null;
    private Integer textArgb = null;
    private Integer backgroundArgb = null;
    private TextMessage.FontType font = null;
    private TextMessage.PreviewType previewType = null;
    private byte[] thumbnail = null;
    private ContextInfo contextInfo = null;
    private boolean doNotPlayInline = false;
    private String thumbnailDirectPath = null;
    private byte[] thumbnailSha256 = null;
    private byte[] thumbnailEncSha256 = null;
    private byte[] mediaKey = null;
    private Long mediaKeyTimestampSeconds = null;
    private Integer thumbnailHeight = null;
    private Integer thumbnailWidth = null;
    private TextMessage.InviteLinkGroupType inviteLinkGroupType = null;
    private String inviteLinkParentGroupSubjectV2 = null;
    private byte[] inviteLinkParentGroupThumbnailV2 = null;
    private TextMessage.InviteLinkGroupType inviteLinkGroupTypeV2 = null;
    private boolean viewOnce = false;

    public TextMessageBuilder text(String text) {
        this.text = text;
        return this;
    }

    public TextMessageBuilder matchedText(String matchedText) {
        this.matchedText = matchedText;
        return this;
    }

    public TextMessageBuilder canonicalUrl(String canonicalUrl) {
        this.canonicalUrl = canonicalUrl;
        return this;
    }

    public TextMessageBuilder description(String description) {
        this.description = description;
        return this;
    }

    public TextMessageBuilder title(String title) {
        this.title = title;
        return this;
    }

    public TextMessageBuilder textArgb(Integer textArgb) {
        this.textArgb = textArgb;
        return this;
    }

    public TextMessageBuilder backgroundArgb(Integer backgroundArgb) {
        this.backgroundArgb = backgroundArgb;
        return this;
    }

    public TextMessageBuilder font(TextMessage.FontType font) {
        this.font = font;
        return this;
    }

    public TextMessageBuilder previewType(TextMessage.PreviewType previewType) {
        this.previewType = previewType;
        return this;
    }

    public TextMessageBuilder thumbnail(byte[] thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public TextMessageBuilder contextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public TextMessageBuilder doNotPlayInline(boolean doNotPlayInline) {
        this.doNotPlayInline = doNotPlayInline;
        return this;
    }

    public TextMessageBuilder thumbnailDirectPath(String thumbnailDirectPath) {
        this.thumbnailDirectPath = thumbnailDirectPath;
        return this;
    }

    public TextMessageBuilder thumbnailSha256(byte[] thumbnailSha256) {
        this.thumbnailSha256 = thumbnailSha256;
        return this;
    }

    public TextMessageBuilder thumbnailEncSha256(byte[] thumbnailEncSha256) {
        this.thumbnailEncSha256 = thumbnailEncSha256;
        return this;
    }

    public TextMessageBuilder mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    public TextMessageBuilder mediaKeyTimestampSeconds(Long mediaKeyTimestampSeconds) {
        this.mediaKeyTimestampSeconds = mediaKeyTimestampSeconds;
        return this;
    }

    public TextMessageBuilder thumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
        return this;
    }

    public TextMessageBuilder thumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
        return this;
    }

    public TextMessageBuilder inviteLinkGroupType(TextMessage.InviteLinkGroupType inviteLinkGroupType) {
        this.inviteLinkGroupType = inviteLinkGroupType;
        return this;
    }

    public TextMessageBuilder inviteLinkParentGroupSubjectV2(String inviteLinkParentGroupSubjectV2) {
        this.inviteLinkParentGroupSubjectV2 = inviteLinkParentGroupSubjectV2;
        return this;
    }

    public TextMessageBuilder inviteLinkParentGroupThumbnailV2(byte[] inviteLinkParentGroupThumbnailV2) {
        this.inviteLinkParentGroupThumbnailV2 = inviteLinkParentGroupThumbnailV2;
        return this;
    }

    public TextMessageBuilder inviteLinkGroupTypeV2(TextMessage.InviteLinkGroupType inviteLinkGroupTypeV2) {
        this.inviteLinkGroupTypeV2 = inviteLinkGroupTypeV2;
        return this;
    }

    public TextMessageBuilder viewOnce(boolean viewOnce) {
        this.viewOnce = viewOnce;
        return this;
    }

    public TextMessage build() {
        return new TextMessage(this.text, this.matchedText, this.canonicalUrl, this.description, this.title, this.textArgb, this.backgroundArgb, this.font, this.previewType, this.thumbnail, this.contextInfo, this.doNotPlayInline, this.thumbnailDirectPath, this.thumbnailSha256, this.thumbnailEncSha256, this.mediaKey, this.mediaKeyTimestampSeconds, this.thumbnailHeight, this.thumbnailWidth, this.inviteLinkGroupType, this.inviteLinkParentGroupSubjectV2, this.inviteLinkParentGroupThumbnailV2, this.inviteLinkGroupTypeV2, this.viewOnce);
    }
}

