/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.newsletter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp.util.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public record NewsletterReactionSettings(Type value, List<String> blockedCodes, OptionalLong enabledTimestampSeconds) {
    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public NewsletterReactionSettings(Type value, @JsonProperty(value="blocked_codes") List<String> blockedCodes, @JsonProperty(value="enabled_ts_sec") Long enabledTimestampSeconds) {
        this(value, (List<String>)Objects.requireNonNullElseGet(blockedCodes, ArrayList::new), Clock.parseTimestamp(enabledTimestampSeconds));
    }

    public static enum Type {
        UNKNOWN,
        ALL,
        BASIC,
        NONE,
        BLOCKLIST;


        public static Type of(String name) {
            return Arrays.stream(Type.values()).filter(entry -> entry.name().equalsIgnoreCase(name)).findFirst().orElse(UNKNOWN);
        }
    }
}

