/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.poll;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.poll.PollUpdate;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptionsSpec;

public class PollUpdateSpec {
    public static byte[] encode(PollUpdate protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, ChatMessageKeySpec.encode(protoInputObject.pollUpdateMessageKey()));
        outputStream.writeBytes(2, PollUpdateEncryptedOptionsSpec.encode(protoInputObject.vote()));
        outputStream.writeInt64(3, Long.valueOf(protoInputObject.senderTimestampMilliseconds()));
        return outputStream.toByteArray();
    }

    public static PollUpdate decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        ChatMessageKey pollUpdateMessageKey = null;
        PollUpdateEncryptedOptions vote = null;
        long senderTimestampMilliseconds = 0L;
        block5: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    pollUpdateMessageKey = ChatMessageKeySpec.decode(inputStream.readBytes());
                    continue block5;
                }
                case 2: {
                    vote = PollUpdateEncryptedOptionsSpec.decode(inputStream.readBytes());
                    continue block5;
                }
                case 3: {
                    senderTimestampMilliseconds = inputStream.readInt64();
                    continue block5;
                }
            }
            inputStream.skipBytes();
        }
        return new PollUpdate(pollUpdateMessageKey, vote, senderTimestampMilliseconds);
    }
}

