/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;

public record SenderChainKey(int iteration, byte[] seed) {
    private static final byte[] MESSAGE_KEY_SEED = new byte[]{1};
    private static final byte[] CHAIN_KEY_SEED = new byte[]{2};

    public SenderMessageKey toMessageKey() {
        byte[] hmac = Hmac.calculateSha256(MESSAGE_KEY_SEED, this.seed);
        return new SenderMessageKey(this.iteration, hmac);
    }

    public SenderChainKey next() {
        byte[] hmac = Hmac.calculateSha256(CHAIN_KEY_SEED, this.seed);
        return new SenderChainKey(this.iteration + 1, hmac);
    }
}

