/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class SenderKeyState {
    private final int id;
    private final SignalKeyPair signingKey;
    private final ConcurrentHashMap<Integer, SenderMessageKey> messageKeys;
    private SenderChainKey chainKey;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SenderKeyState(int id, int iteration, byte[] seed, SignalKeyPair signingKey) {
        this.id = id;
        this.chainKey = new SenderChainKey(iteration, seed);
        this.signingKey = signingKey;
        this.messageKeys = new ConcurrentHashMap();
    }

    public void addSenderMessageKey(SenderMessageKey senderMessageKey) {
        this.messageKeys.put(senderMessageKey.iteration(), senderMessageKey);
    }

    public Optional<SenderMessageKey> findSenderMessageKey(int iteration) {
        return Optional.ofNullable(this.messageKeys.get(iteration));
    }

    public int id() {
        return this.id;
    }

    public SignalKeyPair signingKey() {
        return this.signingKey;
    }

    public SenderChainKey chainKey() {
        return this.chainKey;
    }

    public void setChainKey(SenderChainKey chainKey) {
        this.chainKey = chainKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.id());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof SenderKeyState)) return false;
        SenderKeyState that = (SenderKeyState)other;
        if (!Objects.equals(this.id(), that.id())) return false;
        return true;
    }
}

