/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.model.sync.SyncActionMessage;
import java.util.Collections;
import java.util.List;

@ProtobufMessageName(value="SyncActionValue.SyncActionMessageRange")
public final class ActionMessageRangeSync
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.INT64)
    private Long lastMessageTimestamp;
    @ProtobufProperty(index=2, type=ProtobufType.INT64)
    private Long lastSystemMessageTimestamp;
    @ProtobufProperty(index=3, type=ProtobufType.OBJECT, repeated=true)
    private final List<SyncActionMessage> messages;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ActionMessageRangeSync(Long lastMessageTimestamp, Long lastSystemMessageTimestamp, List<SyncActionMessage> messages) {
        this.lastMessageTimestamp = lastMessageTimestamp;
        this.lastSystemMessageTimestamp = lastSystemMessageTimestamp;
        this.messages = messages;
    }

    public ActionMessageRangeSync(Chat chat, boolean allMessages) {
        chat.newestMessage().ifPresent(message -> {
            this.lastMessageTimestamp = message.timestampSeconds().orElse(0L);
        });
        chat.newestServerMessage().ifPresent(message -> {
            this.lastSystemMessageTimestamp = message.timestampSeconds().orElse(0L);
        });
        this.messages = this.createMessages(chat, allMessages);
    }

    private List<SyncActionMessage> createMessages(Chat chat, boolean allMessages) {
        if (allMessages) {
            return chat.messages().stream().map(HistorySyncMessage::messageInfo).map(this::createActionMessage).toList();
        }
        return chat.newestMessage().map(this::createActionMessage).stream().toList();
    }

    private SyncActionMessage createActionMessage(ChatMessageInfo info) {
        Long timestamp = info != null ? (info.timestampSeconds().isPresent() ? Long.valueOf(info.timestampSeconds().getAsLong()) : null) : null;
        ChatMessageKey key = info != null ? this.checkSenderKey(info.key()) : null;
        return new SyncActionMessage(key, timestamp);
    }

    private ChatMessageKey checkSenderKey(ChatMessageKey key) {
        return key.senderJid().map(entry -> new ChatMessageKey(key.chatJid(), key.fromMe(), key.id(), entry.withoutDevice())).orElse(key);
    }

    public long lastMessageTimestamp() {
        return this.lastMessageTimestamp == null ? 0L : this.lastMessageTimestamp;
    }

    public long lastSystemMessageTimestamp() {
        return this.lastSystemMessageTimestamp == null ? 0L : this.lastSystemMessageTimestamp;
    }

    public List<SyncActionMessage> messages() {
        return Collections.unmodifiableList(this.messages == null ? List.of() : this.messages);
    }
}

