/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.DeviceListMetadata;
import java.util.ArrayList;

public class DeviceListMetadataSpec {
    public static byte[] encode(DeviceListMetadata protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, protoInputObject.senderKeyHash());
        outputStream.writeUInt64(2, protoInputObject.senderTimestamp());
        if (protoInputObject.senderKeyIndexes() != null) {
            for (Integer senderKeyIndexesEntry : protoInputObject.senderKeyIndexes()) {
                outputStream.writeUInt32(3, senderKeyIndexesEntry);
            }
        }
        outputStream.writeBytes(8, protoInputObject.recipientKeyHash());
        outputStream.writeUInt64(9, protoInputObject.recipientTimestamp());
        if (protoInputObject.recipientKeyIndexes() != null) {
            for (Integer recipientKeyIndexesEntry : protoInputObject.recipientKeyIndexes()) {
                outputStream.writeUInt32(10, recipientKeyIndexesEntry);
            }
        }
        return outputStream.toByteArray();
    }

    public static DeviceListMetadata decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        byte[] senderKeyHash = null;
        Long senderTimestamp = null;
        ArrayList<Integer> senderKeyIndexes = new ArrayList<Integer>();
        byte[] recipientKeyHash = null;
        Long recipientTimestamp = null;
        ArrayList<Integer> recipientKeyIndexes = new ArrayList<Integer>();
        block8: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    senderKeyHash = inputStream.readBytes();
                    continue block8;
                }
                case 2: {
                    senderTimestamp = inputStream.readInt64();
                    continue block8;
                }
                case 3: {
                    senderKeyIndexes.addAll(inputStream.readInt32Packed());
                    continue block8;
                }
                case 8: {
                    recipientKeyHash = inputStream.readBytes();
                    continue block8;
                }
                case 9: {
                    recipientTimestamp = inputStream.readInt64();
                    continue block8;
                }
                case 10: {
                    recipientKeyIndexes.addAll(inputStream.readInt32Packed());
                    continue block8;
                }
            }
            inputStream.skipBytes();
        }
        return new DeviceListMetadata(senderKeyHash, senderTimestamp, senderKeyIndexes, recipientKeyHash, recipientTimestamp, recipientKeyIndexes);
    }
}

