/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.extension.OptionalExtension;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.whatsapp.model.sync.HistorySyncTypeSpec;
import java.util.Optional;
import java.util.OptionalLong;

public class HistorySyncNotificationSpec {
    public static byte[] encode(HistorySyncNotification protoInputObject) {
        String peerDataRequestSessionId0;
        Optional<String> peerDataRequestSessionId;
        byte[] initialHistBootstrapInlinePayload0;
        String originalMessageId0;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        byte[] mediaKey0;
        Optional<byte[]> mediaKey;
        Long mediaSize0;
        OptionalLong mediaSize;
        byte[] mediaSha2560;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Optional<byte[]> mediaSha256 = protoInputObject.mediaSha256();
        if (mediaSha256 != null && (mediaSha2560 = (byte[])mediaSha256.orElse(null)) != null) {
            outputStream.writeBytes(1, mediaSha2560);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = OptionalExtension.toNullableLong((OptionalLong)mediaSize)) != null) {
            outputStream.writeUInt64(2, mediaSize0);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = (byte[])mediaKey.orElse(null)) != null) {
            outputStream.writeBytes(3, mediaKey0);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])mediaEncryptedSha256.orElse(null)) != null) {
            outputStream.writeBytes(4, mediaEncryptedSha2560);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)mediaDirectPath.orElse(null)) != null) {
            outputStream.writeString(5, mediaDirectPath0);
        }
        outputStream.writeInt32(6, HistorySyncTypeSpec.encode(protoInputObject.syncType()));
        outputStream.writeUInt32(7, Integer.valueOf(protoInputObject.chunkOrder()));
        Optional<String> originalMessageId = protoInputObject.originalMessageId();
        if (originalMessageId != null && (originalMessageId0 = (String)originalMessageId.orElse(null)) != null) {
            outputStream.writeString(8, originalMessageId0);
        }
        outputStream.writeUInt32(9, Integer.valueOf(protoInputObject.progress()));
        outputStream.writeInt64(10, Long.valueOf(protoInputObject.oldestMsgInChunkTimestampSec()));
        Optional<byte[]> initialHistBootstrapInlinePayload = protoInputObject.initialHistBootstrapInlinePayload();
        if (initialHistBootstrapInlinePayload != null && (initialHistBootstrapInlinePayload0 = (byte[])initialHistBootstrapInlinePayload.orElse(null)) != null) {
            outputStream.writeBytes(11, initialHistBootstrapInlinePayload0);
        }
        if ((peerDataRequestSessionId = protoInputObject.peerDataRequestSessionId()) != null && (peerDataRequestSessionId0 = (String)peerDataRequestSessionId.orElse(null)) != null) {
            outputStream.writeString(12, peerDataRequestSessionId0);
        }
        return outputStream.toByteArray();
    }

    public static HistorySyncNotification decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        byte[] mediaSha256 = null;
        Long mediaSize = null;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        String mediaDirectPath = null;
        HistorySync.Type syncType = null;
        Integer chunkOrder = null;
        String originalMessageId = null;
        int progress = 0;
        long oldestMsgInChunkTimestampSec = 0L;
        byte[] initialHistBootstrapInlinePayload = null;
        String peerDataRequestSessionId = null;
        block14: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    mediaSha256 = inputStream.readBytes();
                    continue block14;
                }
                case 2: {
                    mediaSize = inputStream.readInt64();
                    continue block14;
                }
                case 3: {
                    mediaKey = inputStream.readBytes();
                    continue block14;
                }
                case 4: {
                    mediaEncryptedSha256 = inputStream.readBytes();
                    continue block14;
                }
                case 5: {
                    mediaDirectPath = inputStream.readString();
                    continue block14;
                }
                case 6: {
                    syncType = HistorySyncTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block14;
                }
                case 7: {
                    chunkOrder = inputStream.readInt32();
                    continue block14;
                }
                case 8: {
                    originalMessageId = inputStream.readString();
                    continue block14;
                }
                case 9: {
                    progress = inputStream.readInt32();
                    continue block14;
                }
                case 10: {
                    oldestMsgInChunkTimestampSec = inputStream.readInt64();
                    continue block14;
                }
                case 11: {
                    initialHistBootstrapInlinePayload = inputStream.readBytes();
                    continue block14;
                }
                case 12: {
                    peerDataRequestSessionId = inputStream.readString();
                    continue block14;
                }
            }
            inputStream.skipBytes();
        }
        return new HistorySyncNotification(mediaSha256, mediaSize, mediaKey, mediaEncryptedSha256, mediaDirectPath, syncType, chunkOrder, originalMessageId, progress, oldestMsgInChunkTimestampSec, initialHistBootstrapInlinePayload, peerDataRequestSessionId);
    }
}

