/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.crypto.Hkdf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public record MutationKeys(byte[] indexKey, byte[] encKey, byte[] macKey, byte[] snapshotMacKey, byte[] patchMacKey) {
    private static final int EXPANDED_SIZE = 160;
    private static final byte[] MUTATION_KEYS = "WhatsApp Mutation Keys".getBytes(StandardCharsets.UTF_8);

    public static MutationKeys of(byte[] key) {
        byte[] expanded = Hkdf.extractAndExpand(key, MUTATION_KEYS, 160);
        byte[] indexKey = Arrays.copyOfRange(expanded, 0, 32);
        byte[] encKey = Arrays.copyOfRange(expanded, 32, 64);
        byte[] macKey = Arrays.copyOfRange(expanded, 64, 96);
        byte[] snapshotMacKey = Arrays.copyOfRange(expanded, 96, 128);
        byte[] patchMacKey = Arrays.copyOfRange(expanded, 128, expanded.length);
        return new MutationKeys(indexKey, encKey, macKey, snapshotMacKey, patchMacKey);
    }
}

