/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.KeyIdSpec;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.RecordSyncSpec;
import it.auties.whatsapp.model.sync.SnapshotSync;
import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.whatsapp.model.sync.VersionSyncSpec;
import java.util.ArrayList;

public class SnapshotSyncSpec {
    public static byte[] encode(SnapshotSync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, VersionSyncSpec.encode(protoInputObject.version()));
        if (protoInputObject.records() != null) {
            for (RecordSync recordsEntry : protoInputObject.records()) {
                outputStream.writeBytes(2, RecordSyncSpec.encode(recordsEntry));
            }
        }
        outputStream.writeBytes(3, protoInputObject.mac());
        outputStream.writeBytes(4, KeyIdSpec.encode(protoInputObject.keyId()));
        return outputStream.toByteArray();
    }

    public static SnapshotSync decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        VersionSync version = null;
        ArrayList<RecordSync> records = new ArrayList<RecordSync>();
        byte[] mac = null;
        KeyId keyId = null;
        block6: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    version = VersionSyncSpec.decode(inputStream.readBytes());
                    continue block6;
                }
                case 2: {
                    records.add(RecordSyncSpec.decode(inputStream.readBytes()));
                    continue block6;
                }
                case 3: {
                    mac = inputStream.readBytes();
                    continue block6;
                }
                case 4: {
                    keyId = KeyIdSpec.decode(inputStream.readBytes());
                    continue block6;
                }
            }
            inputStream.skipBytes();
        }
        return new SnapshotSync(version, records, mac, keyId);
    }
}

