/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.linkpreview.LinkPreview;
import it.auties.linkpreview.LinkPreviewMatch;
import it.auties.linkpreview.LinkPreviewMedia;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.crypto.CipheredMessageResult;
import it.auties.whatsapp.crypto.GroupBuilder;
import it.auties.whatsapp.crypto.GroupCipher;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.SessionBuilder;
import it.auties.whatsapp.crypto.SessionCipher;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.model.action.ContactAction;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.button.interactive.InteractiveHeaderAttachment;
import it.auties.whatsapp.model.button.template.TemplateFormatter;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplate;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplate;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitle;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.GroupMetadata;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupPastParticipant;
import it.auties.whatsapp.model.chat.GroupPastParticipants;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoBuilder;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.DeviceContextInfo;
import it.auties.whatsapp.model.info.DeviceContextInfoBuilder;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.jid.JidType;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.media.MediaFile;
import it.auties.whatsapp.model.media.MutableAttachmentProvider;
import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.button.ButtonsResponseMessage;
import it.auties.whatsapp.model.message.button.InteractiveMessage;
import it.auties.whatsapp.model.message.button.ListMessage;
import it.auties.whatsapp.model.message.button.ListResponseMessage;
import it.auties.whatsapp.model.message.button.NativeFlowResponseMessage;
import it.auties.whatsapp.model.message.button.TemplateMessage;
import it.auties.whatsapp.model.message.model.ButtonMessage;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeyBuilder;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageContainerSpec;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.model.reserved.ExtendedMediaMessage;
import it.auties.whatsapp.model.message.payment.PaymentOrderMessage;
import it.auties.whatsapp.model.message.server.DeviceSentMessage;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.message.server.SenderKeyDistributionMessage;
import it.auties.whatsapp.model.message.standard.AudioMessage;
import it.auties.whatsapp.model.message.standard.ContactMessage;
import it.auties.whatsapp.model.message.standard.ContactsMessage;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.whatsapp.model.message.standard.PollUpdateMessage;
import it.auties.whatsapp.model.message.standard.ProductMessage;
import it.auties.whatsapp.model.message.standard.ReactionMessage;
import it.auties.whatsapp.model.message.standard.StickerMessage;
import it.auties.whatsapp.model.message.standard.TextMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterReaction;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.poll.PollAdditionalMetadata;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.model.poll.PollUpdate;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptionsSpec;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.setting.EphemeralSettings;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentitySpec;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.message.SignalDistributionMessage;
import it.auties.whatsapp.model.signal.message.SignalMessage;
import it.auties.whatsapp.model.signal.message.SignalPreKeyMessage;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.sync.AppStateSyncKeyShare;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.whatsapp.model.sync.HistorySyncSpec;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Validate;
import java.io.ByteArrayOutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MessageHandler {
    private static final int HISTORY_SYNC_TIMEOUT = 25;
    private final SocketHandler socketHandler;
    private final Map<Jid, List<GroupPastParticipant>> pastParticipantsQueue;
    private final Set<Jid> historyCache;
    private final System.Logger logger;
    private final EnumSet<HistorySync.Type> historySyncTypes;
    private final ReentrantLock lock;
    private CompletableFuture<?> historySyncTask;

    protected MessageHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
        this.pastParticipantsQueue = new ConcurrentHashMap<Jid, List<GroupPastParticipant>>();
        this.historyCache = ConcurrentHashMap.newKeySet();
        this.logger = System.getLogger("MessageHandler");
        this.historySyncTypes = EnumSet.noneOf(HistorySync.Type.class);
        this.lock = new ReentrantLock(true);
    }

    protected CompletableFuture<Void> encode(MessageSendRequest request) {
        MessageSendRequest messageSendRequest = request;
        Objects.requireNonNull(messageSendRequest);
        MessageSendRequest messageSendRequest2 = messageSendRequest;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MessageSendRequest.Chat.class, MessageSendRequest.Newsletter.class}, (Object)messageSendRequest2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                MessageSendRequest.Chat chatRequest = (MessageSendRequest.Chat)messageSendRequest2;
                yield this.encodeChatMessage(chatRequest);
            }
            case 1 -> {
                MessageSendRequest.Newsletter newsletterRequest = (MessageSendRequest.Newsletter)messageSendRequest2;
                yield this.encodeNewsletterMessage(newsletterRequest);
            }
        };
    }

    private CompletableFuture<Void> encodeChatMessage(MessageSendRequest.Chat request) {
        return ((CompletableFuture)((CompletableFuture)this.prepareOutgoingChatMessage(request.info()).thenComposeAsync(ignored -> {
            try {
                this.lock.lock();
                CompletableFuture<Node> completableFuture = request.peer() || this.isConversation(request.info()) ? this.encodeConversation(request) : this.encodeGroup(request);
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
        })).thenRunAsync(() -> {
            if (request.peer()) {
                return;
            }
            this.saveMessage(request.info(), false);
            this.attributeMessageReceipt(request.info());
        })).exceptionallyAsync(throwable -> {
            request.info().setStatus(MessageStatus.ERROR);
            this.saveMessage(request.info(), false);
            return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, (Throwable)throwable);
        });
    }

    private CompletableFuture<Void> prepareOutgoingChatMessage(MessageInfo messageInfo) {
        CompletableFuture<Object> completableFuture;
        Message message = messageInfo.message().content();
        Objects.requireNonNull(message);
        Message message2 = message;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExtendedMediaMessage.class, ButtonMessage.class, TextMessage.class, PollCreationMessage.class, PollUpdateMessage.class}, (Object)message2, n)) {
                case 0: {
                    ExtendedMediaMessage mediaMessage = (ExtendedMediaMessage)message2;
                    completableFuture = this.attributeMediaMessage(messageInfo.parentJid(), mediaMessage);
                    break block7;
                }
                case 1: {
                    ButtonMessage buttonMessage = (ButtonMessage)message2;
                    completableFuture = this.attributeButtonMessage(messageInfo.parentJid(), buttonMessage);
                    break block7;
                }
                case 2: {
                    TextMessage textMessage = (TextMessage)message2;
                    completableFuture = this.attributeTextMessage(textMessage);
                    break block7;
                }
                case 3: {
                    PollCreationMessage pollCreationMessage = (PollCreationMessage)message2;
                    if (!(messageInfo instanceof ChatMessageInfo)) {
                        n = 4;
                        continue block7;
                    }
                    ChatMessageInfo pollCreationInfo = (ChatMessageInfo)messageInfo;
                    completableFuture = this.attributePollCreationMessage(pollCreationInfo, pollCreationMessage);
                    break block7;
                }
                case 4: {
                    PollUpdateMessage pollUpdateMessage = (PollUpdateMessage)message2;
                    if (!(messageInfo instanceof ChatMessageInfo)) {
                        n = 5;
                        continue block7;
                    }
                    ChatMessageInfo pollUpdateInfo = (ChatMessageInfo)messageInfo;
                    completableFuture = this.attributePollUpdateMessage(pollUpdateInfo, pollUpdateMessage);
                    break block7;
                }
                default: {
                    completableFuture = CompletableFuture.completedFuture(null);
                    break block7;
                }
            }
            break;
        }
        CompletableFuture<Object> result = completableFuture;
        if (messageInfo instanceof ChatMessageInfo) {
            ChatMessageInfo chatMessageInfo = (ChatMessageInfo)messageInfo;
            this.attributeChatMessage(chatMessageInfo);
            this.fixChatMessageKey(chatMessageInfo);
            this.fixEphemeralMessage(chatMessageInfo);
        }
        return result;
    }

    private void fixChatMessageKey(ChatMessageInfo chatMessageInfo) {
        ChatMessageKey key = chatMessageInfo.key();
        key.setChatJid(chatMessageInfo.chatJid().withoutDevice());
        key.setSenderJid(chatMessageInfo.senderJid().withoutDevice());
    }

    private void fixEphemeralMessage(ChatMessageInfo info) {
        if (info.message().hasCategory(MessageCategory.SERVER)) {
            return;
        }
        Chat chat = info.chat().orElse(null);
        if (chat != null && chat.isEphemeral()) {
            info.message().contentWithContext().flatMap(ContextualMessage::contextInfo).ifPresent(contextInfo -> this.createEphemeralContext(chat, (ContextInfo)contextInfo));
            info.setMessage(info.message().toEphemeral());
            return;
        }
        if (info.message().type() != MessageType.EPHEMERAL) {
            return;
        }
        info.setMessage(info.message().unbox());
    }

    private void createEphemeralContext(Chat chat, ContextInfo contextInfo) {
        long period = chat.ephemeralMessageDuration().period().toSeconds();
        contextInfo.setEphemeralExpiration((int)period);
    }

    private CompletableFuture<Void> attributeTextMessage(TextMessage textMessage) {
        if (this.socketHandler.store().textPreviewSetting() == TextPreviewSetting.DISABLED) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return LinkPreview.createPreviewAsync((String)textMessage.text()).thenComposeAsync(result -> this.attributeTextMessage(textMessage, result.orElse(null)));
        }
        catch (NoClassDefFoundError error) {
            return CompletableFuture.completedFuture(null);
        }
    }

    private CompletableFuture<Void> attributeTextMessage(TextMessage textMessage, LinkPreviewMatch match) {
        if (match == null) {
            return CompletableFuture.completedFuture(null);
        }
        String uri = match.result().uri().toString();
        if (this.socketHandler.store().textPreviewSetting() == TextPreviewSetting.ENABLED_WITH_INFERENCE && !Objects.equals(match.text(), uri)) {
            textMessage.setText(textMessage.text().replace(match.text(), uri));
        }
        Optional imageThumbnail = match.result().images().stream().reduce(this::compareDimensions);
        Optional videoUri = match.result().videos().stream().reduce(this::compareDimensions);
        textMessage.setMatchedText(uri);
        textMessage.setCanonicalUrl(videoUri.map(LinkPreviewMedia::uri).orElse(match.result().uri()).toString());
        textMessage.setThumbnailWidth(imageThumbnail.map(LinkPreviewMedia::width).orElse(null));
        textMessage.setThumbnailHeight(imageThumbnail.map(LinkPreviewMedia::height).orElse(null));
        textMessage.setDescription(match.result().siteDescription());
        textMessage.setTitle(match.result().title());
        textMessage.setPreviewType(videoUri.isPresent() ? TextMessage.PreviewType.VIDEO : TextMessage.PreviewType.NONE);
        return imageThumbnail.map(data -> Medias.downloadAsync(data.uri()).thenAccept(textMessage::setThumbnail)).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private LinkPreviewMedia compareDimensions(LinkPreviewMedia first, LinkPreviewMedia second) {
        return first.width() * first.height() > second.width() * second.height() ? first : second;
    }

    private CompletableFuture<Void> attributeMediaMessage(Jid chatJid, ExtendedMediaMessage<?> mediaMessage) {
        byte[] media = mediaMessage.decodedMedia().orElseThrow(() -> new IllegalArgumentException("Missing media to upload"));
        AttachmentType attachmentType = this.getAttachmentType(chatJid, mediaMessage);
        MediaConnection mediaConnection = this.socketHandler.store().mediaConnection();
        return Medias.upload(media, attachmentType, mediaConnection).thenAccept(upload -> this.attributeMediaMessage((MutableAttachmentProvider<?>)mediaMessage, (MediaFile)upload));
    }

    private AttachmentType getAttachmentType(Jid chatJid, ExtendedMediaMessage<?> mediaMessage) {
        if (!chatJid.hasServer(JidServer.NEWSLETTER)) {
            return mediaMessage.attachmentType();
        }
        return switch (mediaMessage.mediaType()) {
            default -> throw new MatchException(null, null);
            case MediaMessageType.IMAGE -> AttachmentType.NEWSLETTER_IMAGE;
            case MediaMessageType.DOCUMENT -> AttachmentType.NEWSLETTER_DOCUMENT;
            case MediaMessageType.AUDIO -> AttachmentType.NEWSLETTER_AUDIO;
            case MediaMessageType.VIDEO -> AttachmentType.NEWSLETTER_VIDEO;
            case MediaMessageType.STICKER -> AttachmentType.NEWSLETTER_STICKER;
            case MediaMessageType.NONE -> throw new IllegalArgumentException("Unexpected empty message");
        };
    }

    private MutableAttachmentProvider<?> attributeMediaMessage(MutableAttachmentProvider<?> mediaMessage, MediaFile upload) {
        if (mediaMessage instanceof ExtendedMediaMessage) {
            ExtendedMediaMessage extendedMediaMessage = (ExtendedMediaMessage)mediaMessage;
            extendedMediaMessage.setHandle(upload.handle());
        }
        return mediaMessage.setMediaSha256(upload.fileSha256()).setMediaEncryptedSha256(upload.fileEncSha256()).setMediaKey(upload.mediaKey()).setMediaUrl(upload.url()).setMediaKeyTimestamp(upload.timestamp()).setMediaDirectPath(upload.directPath()).setMediaSize(upload.fileLength());
    }

    private CompletableFuture<Void> attributePollCreationMessage(ChatMessageInfo info, PollCreationMessage pollCreationMessage) {
        byte[] pollEncryptionKey = pollCreationMessage.encryptionKey().orElseGet(KeyHelper::senderKey);
        pollCreationMessage.setEncryptionKey(pollEncryptionKey);
        info.setMessageSecret(pollEncryptionKey);
        PollAdditionalMetadata metadata = new PollAdditionalMetadata(false);
        info.setPollAdditionalMetadata(metadata);
        info.message().deviceInfo().ifPresentOrElse(deviceInfo -> deviceInfo.setMessageSecret(pollEncryptionKey), () -> {
            DeviceContextInfo deviceInfo = new DeviceContextInfoBuilder().deviceListMetadataVersion(2).messageSecret(pollEncryptionKey).build();
            MessageContainer message = info.message().withDeviceInfo(deviceInfo);
            info.setMessage(message);
        });
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> attributePollUpdateMessage(ChatMessageInfo info, PollUpdateMessage pollUpdateMessage) {
        if (pollUpdateMessage.encryptedMetadata().isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        Optional<Jid> me = this.socketHandler.store().jid();
        if (me.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        String additionalData = "%s\u0000%s".formatted(pollUpdateMessage.pollCreationMessageKey().id(), me.get().withoutDevice());
        List<byte[]> encryptedOptions = pollUpdateMessage.votes().stream().map(entry -> Sha256.calculate(entry.name())).toList();
        byte[] pollUpdateEncryptedOptions = PollUpdateEncryptedOptionsSpec.encode(new PollUpdateEncryptedOptions(encryptedOptions));
        ChatMessageInfo originalPollInfo = this.socketHandler.store().findMessageByKey(pollUpdateMessage.pollCreationMessageKey()).orElseThrow(() -> new NoSuchElementException("Missing original poll message"));
        PollCreationMessage originalPollMessage = (PollCreationMessage)originalPollInfo.message().content();
        byte[] originalPollSender = originalPollInfo.senderJid().withoutDevice().toString().getBytes(StandardCharsets.UTF_8);
        Jid modificationSenderJid = info.senderJid().withoutDevice();
        pollUpdateMessage.setVoter(modificationSenderJid);
        byte[] modificationSender = modificationSenderJid.toString().getBytes(StandardCharsets.UTF_8);
        byte[] secretName = pollUpdateMessage.secretName().getBytes(StandardCharsets.UTF_8);
        byte[] useSecretPayload = BytesHelper.concat(pollUpdateMessage.pollCreationMessageKey().id().getBytes(StandardCharsets.UTF_8), originalPollSender, modificationSender, secretName);
        byte[] encryptionKey = originalPollMessage.encryptionKey().orElseThrow(() -> new NoSuchElementException("Missing encryption key"));
        byte[] useCaseSecret = Hkdf.extractAndExpand(encryptionKey, useSecretPayload, 32);
        byte[] iv = BytesHelper.random(12);
        byte[] pollUpdateEncryptedPayload = AesGcm.encrypt(iv, pollUpdateEncryptedOptions, useCaseSecret, additionalData.getBytes(StandardCharsets.UTF_8));
        PollUpdateEncryptedMetadata pollUpdateEncryptedMetadata = new PollUpdateEncryptedMetadata(pollUpdateEncryptedPayload, iv);
        pollUpdateMessage.setEncryptedMetadata(pollUpdateEncryptedMetadata);
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> attributeButtonMessage(Jid chatJid, ButtonMessage buttonMessage) {
        CompletableFuture<Object> completableFuture;
        ButtonMessage buttonMessage2 = buttonMessage;
        Objects.requireNonNull(buttonMessage2);
        ButtonMessage buttonMessage3 = buttonMessage2;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ButtonsMessage.class, TemplateMessage.class, InteractiveMessage.class}, (Object)buttonMessage3, n)) {
                case 0: {
                    ButtonsMessageHeader buttonsMessageHeader;
                    ButtonsMessage buttonsMessage = (ButtonsMessage)buttonMessage3;
                    if (!buttonsMessage.header().isPresent() || !((buttonsMessageHeader = buttonsMessage.header().get()) instanceof ExtendedMediaMessage)) {
                        n = 1;
                        continue block9;
                    }
                    ExtendedMediaMessage mediaMessage = (ExtendedMediaMessage)((Object)buttonsMessageHeader);
                    completableFuture = this.attributeMediaMessage(chatJid, mediaMessage);
                    break block9;
                }
                case 1: {
                    TemplateFormatter templateFormatter;
                    TemplateMessage templateMessage = (TemplateMessage)buttonMessage3;
                    if (!templateMessage.format().isPresent()) {
                        n = 2;
                        continue block9;
                    }
                    TemplateFormatter templateFormatter2 = templateFormatter = templateMessage.format().get();
                    int n2 = 0;
                    block10: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HighlyStructuredFourRowTemplate.class, HydratedFourRowTemplate.class}, (Object)templateFormatter2, n2)) {
                            case 0: {
                                HighlyStructuredFourRowTemplateTitle highlyStructuredFourRowTemplateTitle;
                                HighlyStructuredFourRowTemplate highlyStructuredFourRowTemplate = (HighlyStructuredFourRowTemplate)templateFormatter2;
                                if (!highlyStructuredFourRowTemplate.title().isPresent() || !((highlyStructuredFourRowTemplateTitle = highlyStructuredFourRowTemplate.title().get()) instanceof ExtendedMediaMessage)) {
                                    n2 = 1;
                                    continue block10;
                                }
                                ExtendedMediaMessage fourRowMedia = (ExtendedMediaMessage)((Object)highlyStructuredFourRowTemplateTitle);
                                completableFuture = this.attributeMediaMessage(chatJid, fourRowMedia);
                                break block9;
                            }
                            case 1: {
                                HydratedFourRowTemplateTitle hydratedFourRowTemplateTitle;
                                HydratedFourRowTemplate hydratedFourRowTemplate = (HydratedFourRowTemplate)templateFormatter2;
                                if (!hydratedFourRowTemplate.title().isPresent() || !((hydratedFourRowTemplateTitle = hydratedFourRowTemplate.title().get()) instanceof ExtendedMediaMessage)) {
                                    n2 = 2;
                                    continue block10;
                                }
                                ExtendedMediaMessage hydratedFourRowMedia = (ExtendedMediaMessage)((Object)hydratedFourRowTemplateTitle);
                                completableFuture = this.attributeMediaMessage(chatJid, hydratedFourRowMedia);
                                break block9;
                            }
                        }
                        break;
                    }
                    completableFuture = CompletableFuture.completedFuture(null);
                    break block9;
                }
                case 2: {
                    InteractiveHeaderAttachment interactiveHeaderAttachment;
                    InteractiveMessage interactiveMessage = (InteractiveMessage)buttonMessage3;
                    if (!(interactiveMessage.header().isPresent() && interactiveMessage.header().get().attachment().isPresent() && (interactiveHeaderAttachment = interactiveMessage.header().get().attachment().get()) instanceof ExtendedMediaMessage)) {
                        n = 3;
                        continue block9;
                    }
                    ExtendedMediaMessage interactiveMedia = (ExtendedMediaMessage)((Object)interactiveHeaderAttachment);
                    completableFuture = this.attributeMediaMessage(chatJid, interactiveMedia);
                    break block9;
                }
                default: {
                    completableFuture = CompletableFuture.completedFuture(null);
                    break block9;
                }
            }
            break;
        }
        return completableFuture;
    }

    private CompletableFuture<Void> encodeNewsletterMessage(MessageSendRequest.Newsletter request) {
        return this.prepareOutgoingChatMessage(request.info()).thenComposeAsync(ignored -> {
            MessageContainer message = request.info().message();
            Node messageNode = this.getPlainMessageNode(message);
            String type = message.isEmpty() || message.content().type() == MessageType.TEXT ? "text" : "media";
            LinkedHashMap<String, Object> attributes = Attributes.ofNullable(request.additionalAttributes()).put("id", request.info().id()).put("to", request.info().parentJid()).put("type", type).put("media_id", this.getPlainMessageHandle(request), Objects::nonNull).toMap();
            return ((CompletableFuture)this.socketHandler.send(Node.of("message", attributes, (Object)messageNode)).thenRunAsync(() -> {
                Newsletter newsletter = request.info().newsletter();
                newsletter.addMessage(request.info());
            })).exceptionallyAsync(throwable -> {
                request.info().setStatus(MessageStatus.ERROR);
                return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, (Throwable)throwable);
            });
        });
    }

    private String getPlainMessageHandle(MessageSendRequest.Newsletter request) {
        Message message = request.info().message().content();
        if (!(message instanceof ExtendedMediaMessage)) {
            return null;
        }
        ExtendedMediaMessage extendedMediaMessage = (ExtendedMediaMessage)message;
        return extendedMediaMessage.handle().orElse(null);
    }

    private Node getPlainMessageNode(MessageContainer message) {
        TextMessage textMessage;
        Message message2 = message.content();
        if (message2 instanceof ReactionMessage) {
            ReactionMessage reactionMessage = (ReactionMessage)message2;
            return Node.of("reaction", Map.of("code", reactionMessage.content()));
        }
        message2 = message.content();
        if (message2 instanceof TextMessage && (textMessage = (TextMessage)message2).thumbnail().isEmpty()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(10);
            byte[] encoded = textMessage.text().getBytes(StandardCharsets.UTF_8);
            byteArrayOutputStream.writeBytes(BytesHelper.intToVarInt(encoded.length));
            byteArrayOutputStream.writeBytes(encoded);
            return Node.of("plaintext", byteArrayOutputStream.toByteArray());
        }
        LinkedHashMap<String, Object> messageAttributes = Attributes.of(new Map.Entry[0]).put("mediatype", this.getMediaType(message), Objects::nonNull).toMap();
        return Node.of("plaintext", messageAttributes, (Object)(message.isEmpty() ? null : MessageContainerSpec.encode(message)));
    }

    private CompletableFuture<Node> encodeGroup(MessageSendRequest.Chat request) {
        byte[] encodedMessage = BytesHelper.messageToBytes(request.info().message());
        Jid sender = this.socketHandler.store().jid().orElse(null);
        if (sender == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cannot create message: user is not signed in"));
        }
        SenderKeyName senderName = new SenderKeyName(request.info().chatJid().toString(), sender.toSignalAddress());
        GroupBuilder groupBuilder = new GroupBuilder(this.socketHandler.keys());
        byte[] signalMessage = groupBuilder.createOutgoing(senderName);
        GroupCipher groupCipher = new GroupCipher(senderName, this.socketHandler.keys());
        CipheredMessageResult groupMessage = groupCipher.encrypt(encodedMessage);
        Node messageNode = this.createMessageNode(request, groupMessage);
        if (request.hasRecipientOverride()) {
            return ((CompletableFuture)((CompletableFuture)this.getDevices(request.recipients(), false).thenComposeAsync(allDevices -> this.createGroupNodes(request, signalMessage, (List<Jid>)allDevices, request.force()))).thenApplyAsync(preKeys -> this.createEncodedMessageNode(request, (List<Node>)preKeys, messageNode))).thenComposeAsync(this.socketHandler::send);
        }
        if (request.force()) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.queryGroupMetadata(request.info().chatJid()).thenComposeAsync(this::getGroupDevices)).thenComposeAsync(allDevices -> this.createGroupNodes(request, signalMessage, (List<Jid>)allDevices, true))).thenApplyAsync(preKeys -> this.createEncodedMessageNode(request, (List<Node>)preKeys, messageNode))).thenComposeAsync(this.socketHandler::send);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.queryGroupMetadata(request.info().chatJid()).thenComposeAsync(this::getGroupDevices)).thenComposeAsync(allDevices -> this.createGroupNodes(request, signalMessage, (List<Jid>)allDevices, false))).thenApplyAsync(preKeys -> this.createEncodedMessageNode(request, (List<Node>)preKeys, messageNode))).thenComposeAsync(this.socketHandler::send);
    }

    private CompletableFuture<Node> encodeConversation(MessageSendRequest.Chat request) {
        Jid sender = this.socketHandler.store().jid().orElse(null);
        if (sender == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cannot create message: user is not signed in"));
        }
        byte[] encodedMessage = BytesHelper.messageToBytes(request.info().message());
        if (request.peer()) {
            Jid chatJid = request.info().chatJid();
            Node peerNode = this.createMessageNode(request, chatJid, encodedMessage, true);
            Node encodedMessageNode = this.createEncodedMessageNode(request, List.of(peerNode), null);
            return this.socketHandler.send(encodedMessageNode);
        }
        List<Jid> knownDevices = this.getRecipients(request, sender);
        DeviceSentMessage deviceMessage = new DeviceSentMessage(request.info().chatJid(), request.info().message(), Optional.empty());
        byte[] encodedDeviceMessage = BytesHelper.messageToBytes(deviceMessage);
        return ((CompletableFuture)((CompletableFuture)this.getDevices(knownDevices, true).thenComposeAsync(allDevices -> this.createConversationNodes(request, (List<Jid>)allDevices, encodedMessage, encodedDeviceMessage))).thenApplyAsync(sessions -> this.createEncodedMessageNode(request, (List<Node>)sessions, null))).thenComposeAsync(this.socketHandler::send);
    }

    private List<Jid> getRecipients(MessageSendRequest.Chat request, Jid sender) {
        if (request.peer()) {
            return List.of(request.info().chatJid());
        }
        if (request.hasRecipientOverride()) {
            return request.recipients();
        }
        return List.of(sender.withoutDevice(), request.info().chatJid());
    }

    private boolean isConversation(ChatMessageInfo info) {
        return info.chatJid().hasServer(JidServer.WHATSAPP) || info.chatJid().hasServer(JidServer.USER);
    }

    private Node createEncodedMessageNode(MessageSendRequest.Chat request, List<Node> preKeys, Node descriptor) {
        ArrayList<Node> body = new ArrayList<Node>();
        if (!preKeys.isEmpty()) {
            if (request.peer()) {
                body.addAll(preKeys);
            } else {
                body.add(Node.of("participants", preKeys));
            }
        }
        if (descriptor != null) {
            body.add(descriptor);
        }
        if (!request.peer() && this.hasPreKeyMessage(preKeys)) {
            this.socketHandler.keys().companionIdentity().ifPresent(companionIdentity -> body.add(Node.of("device-identity", SignedDeviceIdentitySpec.encode(companionIdentity))));
        }
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[1];
        booleanSupplierArray[0] = request::peer;
        LinkedHashMap<String, Object> attributes = Attributes.ofNullable(request.additionalAttributes()).put("id", request.info().id()).put("to", request.info().chatJid()).put("t", (Object)request.info().timestampSeconds().orElseGet(Clock::nowSeconds), !request.peer()).put("type", "text").put("category", (Object)"peer", booleanSupplierArray).put("duration", (Object)"900", request.info().message().type() == MessageType.LIVE_LOCATION).put("device_fanout", (Object)false, request.info().message().type() == MessageType.BUTTONS).put("push_priority", (Object)"high", this.isAppStateKeyShare(request)).toMap();
        return Node.of("message", attributes, body);
    }

    private boolean isAppStateKeyShare(MessageSendRequest.Chat request) {
        ProtocolMessage protocolMessage;
        Message message;
        return request.peer() && (message = request.info().message().content()) instanceof ProtocolMessage && (protocolMessage = (ProtocolMessage)message).protocolType() == ProtocolMessage.Type.APP_STATE_SYNC_KEY_SHARE;
    }

    private boolean hasPreKeyMessage(List<Node> participants) {
        return participants.stream().map(Node::children).flatMap(Collection::stream).map(node -> node.attributes().getOptionalString("type")).flatMap(Optional::stream).anyMatch("pkmsg"::equals);
    }

    private CompletableFuture<List<Node>> createConversationNodes(MessageSendRequest.Chat request, List<Jid> contacts, byte[] message, byte[] deviceMessage) {
        Jid jid = this.socketHandler.store().jid().orElse(null);
        if (jid == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cannot create message: user is not signed in"));
        }
        Map<Boolean, List<Jid>> partitioned = contacts.stream().collect(Collectors.partitioningBy(contact -> Objects.equals(contact.user(), jid.user())));
        CompletionStage companions = this.querySessions(partitioned.get(true), request.force()).thenApplyAsync(ignored -> this.createMessageNodes(request, (List)partitioned.get(true), deviceMessage));
        CompletionStage others = this.querySessions(partitioned.get(false), request.force()).thenApplyAsync(ignored -> this.createMessageNodes(request, (List)partitioned.get(false), message));
        return ((CompletableFuture)companions).thenCombineAsync(others, (first, second) -> this.toSingleList((List)first, (List)second));
    }

    private CompletableFuture<List<Node>> createGroupNodes(MessageSendRequest.Chat request, byte[] distributionMessage, List<Jid> participants, boolean force) {
        List<Jid> missingParticipants = participants.stream().filter(participant -> force || !this.socketHandler.keys().hasGroupKeys(request.info().chatJid(), (Jid)participant)).toList();
        if (missingParticipants.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        SenderKeyDistributionMessage whatsappMessage = new SenderKeyDistributionMessage(request.info().chatJid().toString(), distributionMessage);
        byte[] paddedMessage = BytesHelper.messageToBytes(whatsappMessage);
        return ((CompletableFuture)this.querySessions(missingParticipants, force).thenApplyAsync(ignored -> this.createMessageNodes(request, missingParticipants, paddedMessage))).thenApplyAsync(results -> {
            this.socketHandler.keys().addRecipientsWithPreKeys(request.info().chatJid(), missingParticipants);
            return results;
        });
    }

    protected CompletableFuture<Void> querySessions(List<Jid> contacts, boolean force) {
        List<Node> missingSessions = contacts.stream().filter(contact -> force || !this.socketHandler.keys().hasSession(contact.toSignalAddress())).map(contact -> Node.of("user", Map.of("jid", contact))).toList();
        return missingSessions.isEmpty() ? CompletableFuture.completedFuture(null) : this.querySession(missingSessions);
    }

    private CompletableFuture<Void> querySession(List<Node> children) {
        return this.socketHandler.sendQuery("get", "encrypt", Node.of("key", children)).thenAcceptAsync(this::parseSessions);
    }

    private List<Node> createMessageNodes(MessageSendRequest.Chat request, List<Jid> contacts, byte[] message) {
        return contacts.stream().map(contact -> this.createMessageNode(request, (Jid)contact, message, false)).toList();
    }

    private Node createMessageNode(MessageSendRequest.Chat request, Jid contact, byte[] message, boolean peer) {
        SessionCipher cipher = new SessionCipher(contact.toSignalAddress(), this.socketHandler.keys());
        CipheredMessageResult encrypted = cipher.encrypt(message);
        Node messageNode = this.createMessageNode(request, encrypted);
        return peer ? messageNode : Node.of("to", Map.of("jid", contact), (Object)messageNode);
    }

    private CompletableFuture<List<Jid>> getGroupDevices(GroupMetadata metadata) {
        List<Jid> jids = metadata.participants().stream().map(GroupParticipant::jid).toList();
        return this.getDevices(jids, false);
    }

    protected CompletableFuture<List<Jid>> getDevices(List<Jid> contacts, boolean excludeSelf) {
        return this.queryDevices(contacts, excludeSelf).thenApplyAsync(missingDevices -> excludeSelf ? this.toSingleList((List)contacts, (List)missingDevices) : missingDevices);
    }

    private CompletableFuture<List<Jid>> queryDevices(List<Jid> contacts, boolean excludeSelf) {
        List<Node> contactNodes = contacts.stream().map(contact -> Node.of("user", Map.of("jid", contact))).toList();
        Node body = Node.of("usync", Map.of("sid", ChatMessageKey.randomId(), "mode", "query", "last", "true", "index", "0", "context", "message"), Node.of("query", (Object)Node.of("devices", Map.of("version", "2"))), Node.of("list", contactNodes));
        return this.socketHandler.sendQuery("get", "usync", body).thenApplyAsync(result -> this.parseDevices((Node)result, excludeSelf));
    }

    private List<Jid> parseDevices(Node node, boolean excludeSelf) {
        return node.children().stream().map(child -> child.findNode("list")).flatMap(Optional::stream).map(Node::children).flatMap(Collection::stream).map(entry -> this.parseDevice((Node)entry, excludeSelf)).flatMap(Collection::stream).toList();
    }

    private List<Jid> parseDevice(Node wrapper, boolean excludeSelf) {
        Jid jid = wrapper.attributes().getRequiredJid("jid");
        return wrapper.findNode("devices").orElseThrow(() -> new NoSuchElementException("Missing devices")).findNode("device-list").orElseThrow(() -> new NoSuchElementException("Missing device list")).children().stream().map(child -> this.parseDeviceId((Node)child, jid, excludeSelf)).flatMap(Optional::stream).map(id -> Jid.ofDevice(jid.user(), id)).toList();
    }

    private Optional<Integer> parseDeviceId(Node child, Jid jid, boolean excludeSelf) {
        Jid self = this.socketHandler.store().jid().orElse(null);
        if (self == null) {
            return Optional.empty();
        }
        int deviceId = child.attributes().getInt("id");
        return !(!child.description().equals("device") || excludeSelf && deviceId == 0 || jid.user().equals(self.user()) && self.device() == deviceId || deviceId != 0 && !child.attributes().hasKey("key-index")) ? Optional.of(deviceId) : Optional.empty();
    }

    protected void parseSessions(Node node) {
        node.findNode("list").orElseThrow(() -> new IllegalArgumentException("Cannot parse sessions: " + String.valueOf(node))).findNodes("user").forEach(this::parseSession);
    }

    private void parseSession(Node node) {
        Validate.isTrue(!node.hasNode("error"), "Erroneous session node", SecurityException.class, new Object[0]);
        Jid jid = node.attributes().getRequiredJid("jid");
        Integer registrationId = node.findNode("registration").map(id -> BytesHelper.bytesToInt(id.contentAsBytes().orElseThrow(), 4)).orElseThrow(() -> new NoSuchElementException("Missing id"));
        byte[] identity = node.findNode("identity").flatMap(Node::contentAsBytes).map(KeyHelper::withHeader).orElseThrow(() -> new NoSuchElementException("Missing identity"));
        SignalSignedKeyPair signedKey = (SignalSignedKeyPair)node.findNode("skey").flatMap(SignalSignedKeyPair::of).orElseThrow(() -> new NoSuchElementException("Missing signed key"));
        SignalSignedKeyPair key = node.findNode("key").flatMap(SignalSignedKeyPair::of).orElse(null);
        SessionBuilder builder = new SessionBuilder(jid.toSignalAddress(), this.socketHandler.keys());
        builder.createOutgoing(registrationId, identity, signedKey, key);
    }

    public void decode(Node node, JidProvider chatOverride, boolean notify) {
        try {
            String businessName = this.getBusinessName(node);
            if (node.hasNode("unavailable")) {
                this.decodeChatMessage(node, null, businessName, notify);
                return;
            }
            List<Node> encrypted = node.findNodes("enc");
            if (!encrypted.isEmpty()) {
                encrypted.forEach(message -> this.decodeChatMessage(node, (Node)message, businessName, notify));
                return;
            }
            Optional<Node> plainText = node.findNode("plaintext");
            if (plainText.isPresent()) {
                this.decodeNewsletterMessage(node, plainText.get(), businessName, chatOverride, notify);
                return;
            }
            Optional<Node> reaction = node.findNode("reaction");
            if (reaction.isPresent()) {
                this.decodeNewsletterReaction(node, reaction.get(), businessName, chatOverride, notify);
                return;
            }
            this.decodeChatMessage(node, null, businessName, notify);
        }
        catch (Throwable throwable) {
            this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
        }
    }

    private String getBusinessName(Node node) {
        return node.attributes().getOptionalString("verified_name").or(() -> MessageHandler.getBusinessNameFromNode(node)).orElse(null);
    }

    private static Optional<String> getBusinessNameFromNode(Node node) {
        return node.findNode("verified_name").flatMap(Node::contentAsBytes).map(BusinessVerifiedNameCertificateSpec::decode).map(certificate -> certificate.details().name());
    }

    private Node createMessageNode(MessageSendRequest.Chat request, CipheredMessageResult groupMessage) {
        String mediaType = this.getMediaType(request.info().message());
        Attributes attributes = Attributes.of(new Map.Entry[0]).put("v", "2").put("type", groupMessage.type()).put("mediatype", mediaType, Objects::nonNull);
        return Node.of("enc", attributes, (Object)groupMessage.message());
    }

    private String getMediaType(MessageContainer container) {
        Message content;
        Message message = content = container.content();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageMessage.class, VideoOrGifMessage.class, AudioMessage.class, ContactMessage.class, DocumentMessage.class, ContactsMessage.class, LiveLocationMessage.class, StickerMessage.class, ListMessage.class, ListResponseMessage.class, ButtonsResponseMessage.class, PaymentOrderMessage.class, ProductMessage.class, NativeFlowResponseMessage.class, ButtonsMessage.class}, (Object)message, n)) {
            case 0 -> {
                ImageMessage imageMessage = (ImageMessage)message;
                yield "image";
            }
            case 1 -> {
                VideoOrGifMessage videoMessage = (VideoOrGifMessage)message;
                if (videoMessage.gifPlayback()) {
                    yield "gif";
                }
                yield "video";
            }
            case 2 -> {
                AudioMessage audioMessage = (AudioMessage)message;
                if (audioMessage.voiceMessage()) {
                    yield "ptt";
                }
                yield "audio";
            }
            case 3 -> {
                ContactMessage contactMessage = (ContactMessage)message;
                yield "vcard";
            }
            case 4 -> {
                DocumentMessage documentMessage = (DocumentMessage)message;
                yield "document";
            }
            case 5 -> {
                ContactsMessage contactsMessage = (ContactsMessage)message;
                yield "contact_array";
            }
            case 6 -> {
                LiveLocationMessage liveLocationMessage = (LiveLocationMessage)message;
                yield "livelocation";
            }
            case 7 -> {
                StickerMessage stickerMessage = (StickerMessage)message;
                yield "sticker";
            }
            case 8 -> {
                ListMessage listMessage = (ListMessage)message;
                yield "list";
            }
            case 9 -> {
                ListResponseMessage listResponseMessage = (ListResponseMessage)message;
                yield "list_response";
            }
            case 10 -> {
                ButtonsResponseMessage buttonsResponseMessage = (ButtonsResponseMessage)message;
                yield "buttons_response";
            }
            case 11 -> {
                PaymentOrderMessage paymentOrderMessage = (PaymentOrderMessage)message;
                yield "order";
            }
            case 12 -> {
                ProductMessage productMessage = (ProductMessage)message;
                yield "product";
            }
            case 13 -> {
                NativeFlowResponseMessage nativeFlowResponseMessage = (NativeFlowResponseMessage)message;
                yield "native_flow_response";
            }
            case 14 -> {
                ButtonsMessage buttonsMessage = (ButtonsMessage)message;
                if (buttonsMessage.headerType().hasMedia()) {
                    yield buttonsMessage.headerType().name().toLowerCase();
                }
                yield null;
            }
            default -> null;
        };
    }

    private void decodeNewsletterMessage(Node messageNode, Node plainTextNode, String businessName, JidProvider chatOverride, boolean notify) {
        try {
            Optional<Newsletter> newsletter;
            Jid newsletterJid = messageNode.attributes().getOptionalJid("from").or(() -> Optional.ofNullable(chatOverride).map(JidProvider::toJid)).orElseThrow(() -> new NoSuchElementException("Missing from"));
            String messageId = messageNode.attributes().getRequiredString("id");
            if (notify) {
                this.socketHandler.sendMessageAck(newsletterJid, messageNode);
                String receiptType = this.getReceiptType("newsletter", false);
                this.socketHandler.sendReceipt(newsletterJid, null, List.of(messageId), receiptType);
            }
            if ((newsletter = this.socketHandler.store().findNewsletterByJid(newsletterJid)).isEmpty()) {
                return;
            }
            int serverId = messageNode.attributes().getRequiredInt("server_id");
            Long timestamp = messageNode.attributes().getNullableLong("t");
            Long views = messageNode.findNode("views_count").map(value -> value.attributes().getNullableLong("count")).orElse(null);
            ConcurrentMap<String, NewsletterReaction> reactions = messageNode.findNode("reactions").stream().map(node -> node.findNodes("reaction")).flatMap(Collection::stream).collect(Collectors.toConcurrentMap(entry -> entry.attributes().getRequiredString("code"), entry -> new NewsletterReaction(entry.attributes().getRequiredString("code"), entry.attributes().getLong("count"), entry.attributes().getBoolean("is_sender"))));
            Optional<NewsletterMessageInfo> result = plainTextNode.contentAsBytes().map(MessageContainerSpec::decode).map(messageContainer -> {
                MessageStatus readStatus = notify ? MessageStatus.DELIVERED : MessageStatus.READ;
                return new NewsletterMessageInfo((Newsletter)newsletter.get(), messageId, serverId, timestamp, views, (Map<String, NewsletterReaction>)reactions, (MessageContainer)messageContainer, readStatus);
            });
            if (result.isEmpty()) {
                return;
            }
            newsletter.get().addMessage(result.get());
            if (notify) {
                this.socketHandler.onNewsletterMessage(result.get());
            }
        }
        catch (Throwable throwable) {
            this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
        }
    }

    private void decodeNewsletterReaction(Node messageNode, Node reactionNode, String businessName, JidProvider chatOverride, boolean notify) {
        try {
            Optional<String> code;
            NewsletterReaction myReaction;
            Optional<Newsletter> newsletter;
            String messageId = messageNode.attributes().getRequiredString("id");
            Jid newsletterJid = messageNode.attributes().getOptionalJid("from").or(() -> Optional.ofNullable(chatOverride).map(JidProvider::toJid)).orElseThrow(() -> new NoSuchElementException("Missing from"));
            boolean isSender = messageNode.attributes().getBoolean("is_sender");
            if (notify) {
                this.socketHandler.sendMessageAck(newsletterJid, messageNode);
                String receiptType = this.getReceiptType("newsletter", false);
                this.socketHandler.sendReceipt(newsletterJid, null, List.of(messageId), receiptType);
            }
            if ((newsletter = this.socketHandler.store().findNewsletterByJid(newsletterJid)).isEmpty()) {
                return;
            }
            Optional<NewsletterMessageInfo> message = this.socketHandler.store().findMessageById(newsletter.get(), messageId);
            if (message.isEmpty()) {
                return;
            }
            NewsletterReaction newsletterReaction = myReaction = isSender ? (NewsletterReaction)message.get().reactions().stream().filter(NewsletterReaction::fromMe).findFirst().orElse(null) : null;
            if (myReaction != null) {
                message.get().decrementReaction(myReaction.content());
            }
            if ((code = reactionNode.attributes().getOptionalString("code")).isEmpty()) {
                return;
            }
            message.get().incrementReaction(code.get(), isSender);
        }
        catch (Throwable throwable) {
            this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeChatMessage(Node infoNode, Node messageNode, String businessName, boolean notify) {
        try {
            byte[] encodedMessage;
            this.lock.lock();
            String pushName = infoNode.attributes().getNullableString("notify");
            long timestamp = infoNode.attributes().getLong("t");
            String id = infoNode.attributes().getRequiredString("id");
            Jid from = infoNode.attributes().getRequiredJid("from");
            Jid recipient = infoNode.attributes().getOptionalJid("recipient").orElse(from);
            Jid participant = infoNode.attributes().getOptionalJid("participant").orElse(null);
            ChatMessageInfoBuilder messageBuilder = new ChatMessageInfoBuilder().status(MessageStatus.PENDING);
            ChatMessageKeyBuilder keyBuilder = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId());
            Jid receiver = this.socketHandler.store().jid().map(Jid::withoutDevice).orElse(null);
            if (receiver == null) {
                return;
            }
            if (from.hasServer(JidServer.WHATSAPP) || from.hasServer(JidServer.USER)) {
                keyBuilder.chatJid(recipient);
                keyBuilder.senderJid(from);
                keyBuilder.fromMe(Objects.equals(from.withoutDevice(), receiver));
                messageBuilder.senderJid(from);
            } else {
                keyBuilder.chatJid(from);
                keyBuilder.senderJid(Objects.requireNonNull(participant, "Missing participant in group message"));
                keyBuilder.fromMe(Objects.equals(participant.withoutDevice(), receiver));
                messageBuilder.senderJid(Objects.requireNonNull(participant, "Missing participant in group message"));
            }
            ChatMessageKey key = keyBuilder.id(id).build();
            if (Objects.equals(key.senderJid().orElse(null), this.socketHandler.store().jid().orElse(null))) {
                this.sendEncMessageReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
                return;
            }
            if (messageNode == null) {
                this.logger.log(System.Logger.Level.WARNING, "Cannot decode message(id: %s, from: %s)".formatted(id, from));
                this.sendEncMessageReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
                return;
            }
            String type = messageNode.attributes().getRequiredString("type");
            MessageDecodeResult decodedMessage = this.decodeMessageBytes(type, encodedMessage = (byte[])messageNode.contentAsBytes().orElse(null), from, participant);
            if (decodedMessage.hasError()) {
                this.logger.log(System.Logger.Level.WARNING, "Cannot decode message(id: %s, from: %s): %s".formatted(id, from, decodedMessage.error().getMessage()));
                this.sendEncMessageReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
                return;
            }
            MessageContainer messageContainer = BytesHelper.bytesToMessage(decodedMessage.message()).unbox();
            ChatMessageInfo info = messageBuilder.key(key).broadcast(key.chatJid().hasServer(JidServer.BROADCAST)).pushName(pushName).status(MessageStatus.DELIVERED).businessVerifiedName(businessName).timestampSeconds(timestamp).message(messageContainer).build();
            this.attributeMessageReceipt(info);
            this.attributeChatMessage(info);
            this.saveMessage(info, notify);
            this.socketHandler.onReply(info);
            this.sendEncMessageReceipt(infoNode, id, key.chatJid(), key.senderJid().orElse(null), key.fromMe());
        }
        catch (Throwable throwable) {
            this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private CompletableFuture<Void> sendEncMessageReceipt(Node infoNode, String id, Jid chatJid, Jid senderJid, boolean fromMe) {
        Jid participant = fromMe && senderJid == null ? chatJid : senderJid;
        String category = infoNode.attributes().getString("category");
        String receiptType = this.getReceiptType(category, fromMe);
        return this.socketHandler.sendMessageAck(chatJid, infoNode).thenComposeAsync(ignored -> this.socketHandler.sendReceipt(chatJid, participant, List.of(id), receiptType));
    }

    private String getReceiptType(String category, boolean fromMe) {
        if (Objects.equals(category, "peer")) {
            return "peer_msg";
        }
        if (fromMe) {
            return "sender";
        }
        if (!this.socketHandler.store().online()) {
            return "inactive";
        }
        return null;
    }

    private MessageDecodeResult decodeMessageBytes(String type, byte[] encodedMessage, Jid from, Jid participant) {
        try {
            if (encodedMessage == null) {
                return new MessageDecodeResult(null, new IllegalArgumentException("Missing encoded message"));
            }
            byte[] result = switch (type) {
                case "skmsg" -> {
                    Objects.requireNonNull(participant, "Cannot decipher skmsg without participant");
                    SenderKeyName senderName = new SenderKeyName(from.toString(), participant.toSignalAddress());
                    GroupCipher signalGroup = new GroupCipher(senderName, this.socketHandler.keys());
                    yield signalGroup.decrypt(encodedMessage);
                }
                case "pkmsg" -> {
                    Jid user = from.hasServer(JidServer.WHATSAPP) ? from : participant;
                    Objects.requireNonNull(user, "Cannot decipher pkmsg without user");
                    SessionCipher session = new SessionCipher(user.toSignalAddress(), this.socketHandler.keys());
                    SignalPreKeyMessage preKey = SignalPreKeyMessage.ofSerialized(encodedMessage);
                    yield session.decrypt(preKey);
                }
                case "msg" -> {
                    Jid user = from.hasServer(JidServer.WHATSAPP) ? from : participant;
                    Objects.requireNonNull(user, "Cannot decipher msg without user");
                    SessionCipher session = new SessionCipher(user.toSignalAddress(), this.socketHandler.keys());
                    SignalMessage signalMessage = SignalMessage.ofSerialized(encodedMessage);
                    yield session.decrypt(signalMessage);
                }
                default -> throw new IllegalArgumentException("Unsupported encoded message type: %s".formatted(type));
            };
            return new MessageDecodeResult(result, null);
        }
        catch (Throwable throwable) {
            return new MessageDecodeResult(null, throwable);
        }
    }

    private void attributeMessageReceipt(ChatMessageInfo info) {
        Jid self = this.socketHandler.store().jid().map(Jid::withoutDevice).orElse(null);
        if (!info.fromMe() || self != null && !info.chatJid().equals(self)) {
            return;
        }
        info.receipt().readTimestampSeconds(info.timestampSeconds().orElse(0L));
        info.receipt().deliveredJids().add(self);
        info.receipt().readJids().add(self);
        info.setStatus(MessageStatus.READ);
    }

    private void saveMessage(ChatMessageInfo info, boolean notify) {
        Message message = info.message().content();
        if (message instanceof SenderKeyDistributionMessage) {
            SenderKeyDistributionMessage distributionMessage = (SenderKeyDistributionMessage)message;
            this.handleDistributionMessage(distributionMessage, info.senderJid());
        }
        if (info.chatJid().type() == JidType.STATUS) {
            this.socketHandler.store().addStatus(info);
            this.socketHandler.onNewStatus(info);
            return;
        }
        if (info.message().hasCategory(MessageCategory.SERVER)) {
            message = info.message().content();
            if (message instanceof ProtocolMessage) {
                ProtocolMessage protocolMessage = (ProtocolMessage)message;
                this.handleProtocolMessage(info, protocolMessage);
            }
            return;
        }
        Chat chat = info.chat().orElseGet(() -> this.socketHandler.store().addNewChat(info.chatJid()));
        boolean result = chat.addNewMessage(info);
        if (!result || info.timestampSeconds().orElse(0L) <= this.socketHandler.store().initializationTimeStamp()) {
            return;
        }
        if (chat.archived() && this.socketHandler.store().unarchiveChats()) {
            chat.setArchived(false);
        }
        info.sender().filter(this::isTyping).ifPresent(sender -> this.socketHandler.onUpdateChatPresence(ContactStatus.AVAILABLE, sender.jid(), chat));
        if (!info.ignore() && !info.fromMe()) {
            chat.setUnreadMessagesCount(chat.unreadMessagesCount() + 1);
        }
        if (notify) {
            this.socketHandler.onNewMessage(info);
        }
    }

    private void handleDistributionMessage(SenderKeyDistributionMessage distributionMessage, Jid from) {
        SenderKeyName groupName = new SenderKeyName(distributionMessage.groupId(), from.toSignalAddress());
        GroupBuilder builder = new GroupBuilder(this.socketHandler.keys());
        SignalDistributionMessage message = SignalDistributionMessage.ofSerialized(distributionMessage.data());
        builder.createIncoming(groupName, message);
    }

    private void handleProtocolMessage(ChatMessageInfo info, ProtocolMessage protocolMessage) {
        switch (protocolMessage.protocolType()) {
            case HISTORY_SYNC_NOTIFICATION: {
                this.onHistorySyncNotification(info, protocolMessage);
                break;
            }
            case APP_STATE_SYNC_KEY_SHARE: {
                this.onAppStateSyncKeyShare(protocolMessage);
                break;
            }
            case REVOKE: {
                this.onMessageRevoked(info, protocolMessage);
                break;
            }
            case EPHEMERAL_SETTING: {
                this.onEphemeralSettings(info, protocolMessage);
            }
        }
    }

    private void onEphemeralSettings(ChatMessageInfo info, ProtocolMessage protocolMessage) {
        Chat chat = info.chat().orElse(null);
        long timestampSeconds = info.timestampSeconds().orElse(0L);
        if (chat != null) {
            chat.setEphemeralMessagesToggleTimeSeconds(timestampSeconds);
            chat.setEphemeralMessageDuration(ChatEphemeralTimer.of((int)protocolMessage.ephemeralExpiration()));
        }
        EphemeralSettings setting = new EphemeralSettings((int)protocolMessage.ephemeralExpiration(), timestampSeconds);
        this.socketHandler.onSetting(setting);
    }

    private void onMessageRevoked(ChatMessageInfo info, ProtocolMessage protocolMessage) {
        String id = protocolMessage.key().orElseThrow().id();
        info.chat().flatMap(chat -> this.socketHandler.store().findMessageById((Chat)chat, id)).ifPresent(message -> this.onMessageDeleted(info, (ChatMessageInfo)message));
    }

    private void onAppStateSyncKeyShare(ProtocolMessage protocolMessage) {
        AppStateSyncKeyShare data = protocolMessage.appStateSyncKeyShare().orElseThrow(() -> new NoSuchElementException("Missing app state keys"));
        Jid self = this.socketHandler.store().jid().orElseThrow(() -> new IllegalStateException("The session isn't connected"));
        this.socketHandler.keys().addAppKeys(self, data.keys());
        this.socketHandler.pullInitialPatches().exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.UNKNOWN, (Throwable)throwable));
    }

    private void onHistorySyncNotification(ChatMessageInfo info, ProtocolMessage protocolMessage) {
        if (this.isZeroHistorySyncComplete()) {
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.downloadHistorySync(protocolMessage).thenAcceptAsync(history -> this.onHistoryNotification(info, (HistorySync)history))).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.HISTORY_SYNC, (Throwable)throwable))).thenRunAsync(() -> this.socketHandler.sendReceipt(info.chatJid(), null, List.of(info.id()), "hist_sync"));
    }

    private boolean isZeroHistorySyncComplete() {
        return this.socketHandler.store().historyLength().isZero() && this.historySyncTypes.contains((Object)HistorySync.Type.INITIAL_STATUS_V3) && this.historySyncTypes.contains((Object)HistorySync.Type.PUSH_NAME) && this.historySyncTypes.contains((Object)HistorySync.Type.INITIAL_BOOTSTRAP) && this.historySyncTypes.contains((Object)HistorySync.Type.NON_BLOCKING_DATA);
    }

    private boolean isTyping(Contact sender) {
        return sender.lastKnownPresence() == ContactStatus.COMPOSING || sender.lastKnownPresence() == ContactStatus.RECORDING;
    }

    private CompletableFuture<HistorySync> downloadHistorySync(ProtocolMessage protocolMessage) {
        return protocolMessage.historySyncNotification().map(this::downloadHistorySyncNotification).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private CompletableFuture<HistorySync> downloadHistorySyncNotification(HistorySyncNotification notification) {
        return notification.initialHistBootstrapInlinePayload().map(result -> CompletableFuture.completedFuture(HistorySyncSpec.decode(BytesHelper.decompress(result)))).orElseGet(() -> ((CompletableFuture)Medias.downloadAsync(notification).thenApplyAsync(entry -> (byte[])entry.orElseThrow(() -> new NoSuchElementException("Cannot download history sync")))).thenApplyAsync(result -> HistorySyncSpec.decode(BytesHelper.decompress(result))));
    }

    private void onHistoryNotification(ChatMessageInfo info, HistorySync history) {
        this.handleHistorySync(history);
        if (history.progress() == null) {
            return;
        }
        this.socketHandler.onHistorySyncProgress(history.progress(), history.syncType() == HistorySync.Type.RECENT);
    }

    private void onMessageDeleted(ChatMessageInfo info, ChatMessageInfo message) {
        info.chat().ifPresent(chat -> chat.removeMessage(message));
        message.setRevokeTimestampSeconds(Clock.nowSeconds());
        this.socketHandler.onMessageDeleted(message, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleHistorySync(HistorySync history) {
        try {
            switch (history.syncType()) {
                case INITIAL_STATUS_V3: {
                    this.handleInitialStatus(history);
                    return;
                }
                case PUSH_NAME: {
                    this.handlePushNames(history);
                    return;
                }
                case INITIAL_BOOTSTRAP: {
                    this.handleInitialBootstrap(history);
                    return;
                }
                case RECENT: 
                case FULL: {
                    this.handleChatsSync(history);
                    return;
                }
                case NON_BLOCKING_DATA: {
                    this.handleNonBlockingData(history);
                    return;
                }
            }
            return;
        }
        finally {
            this.historySyncTypes.add(history.syncType());
        }
    }

    private void handleInitialStatus(HistorySync history) {
        Store store = this.socketHandler.store();
        for (ChatMessageInfo messageInfo : history.statusV3Messages()) {
            this.socketHandler.store().addStatus(messageInfo);
        }
        this.socketHandler.onStatus();
    }

    private void handlePushNames(HistorySync history) {
        for (PushName pushName : history.pushNames()) {
            this.handNewPushName(pushName);
        }
        this.socketHandler.onContacts();
    }

    private void handNewPushName(PushName pushName) {
        Jid jid = Jid.of(pushName.id());
        Contact contact = this.socketHandler.store().findContactByJid(jid).orElseGet(() -> this.createNewContact(jid));
        pushName.name().ifPresent(contact::setChosenName);
        ContactAction action = new ContactAction(pushName.name(), Optional.empty(), Optional.empty());
        this.socketHandler.onAction(action, MessageIndexInfo.of("contact", jid, null, true));
    }

    private Contact createNewContact(Jid jid) {
        Contact contact = this.socketHandler.store().addContact(jid);
        this.socketHandler.onNewContact(contact);
        return contact;
    }

    private void handleInitialBootstrap(HistorySync history) {
        if (!this.socketHandler.store().historyLength().isZero()) {
            List<Jid> jids = history.conversations().stream().map(Chat::jid).toList();
            this.historyCache.addAll(jids);
        }
        this.handleConversations(history);
        this.socketHandler.onChats();
    }

    private void handleChatsSync(HistorySync history) {
        if (this.socketHandler.store().historyLength().isZero()) {
            return;
        }
        this.handleConversations(history);
        this.handleConversationsNotifications(history);
        this.scheduleHistorySyncTimeout();
    }

    private void handleConversationsNotifications(HistorySync history) {
        HashSet<Jid> toRemove = new HashSet<Jid>();
        for (Jid cachedJid : this.historyCache) {
            boolean done;
            Chat chat = this.socketHandler.store().findChatByJid(cachedJid).orElse(null);
            if (chat == null) continue;
            boolean bl = done = !history.conversations().contains(chat);
            if (done) {
                chat.setEndOfHistoryTransfer(true);
                chat.setEndOfHistoryTransferType(Chat.EndOfHistoryTransferType.COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY);
                toRemove.add(cachedJid);
            }
            this.socketHandler.onChatRecentMessages(chat, done);
        }
        this.historyCache.removeAll(toRemove);
    }

    private void scheduleHistorySyncTimeout() {
        Executor executor = CompletableFuture.delayedExecutor(25L, TimeUnit.SECONDS);
        if (this.historySyncTask != null) {
            this.historySyncTask.cancel(true);
        }
        this.historySyncTask = CompletableFuture.runAsync(this::onForcedHistorySyncCompletion, executor);
    }

    private void onForcedHistorySyncCompletion() {
        for (Jid cachedJid : this.historyCache) {
            Chat chat = this.socketHandler.store().findChatByJid(cachedJid).orElse(null);
            if (chat == null) continue;
            this.socketHandler.onChatRecentMessages(chat, true);
        }
        this.historyCache.clear();
    }

    private void handleConversations(HistorySync history) {
        Store store = this.socketHandler.store();
        for (Chat chat : history.conversations()) {
            for (HistorySyncMessage message : chat.messages()) {
                this.attributeChatMessage(message.messageInfo());
            }
            List<GroupPastParticipant> pastParticipants = this.pastParticipantsQueue.remove(chat.jid());
            if (pastParticipants != null) {
                chat.addPastParticipants(pastParticipants);
            }
            this.socketHandler.store().addChat(chat);
        }
    }

    private void handleNonBlockingData(HistorySync history) {
        for (GroupPastParticipants pastParticipants : history.pastParticipants()) {
            this.handlePastParticipants(pastParticipants);
        }
    }

    private void handlePastParticipants(GroupPastParticipants pastParticipants) {
        this.socketHandler.store().findChatByJid(pastParticipants.groupJid()).ifPresentOrElse(chat -> chat.addPastParticipants(pastParticipants.pastParticipants()), () -> this.pastParticipantsQueue.put(pastParticipants.groupJid(), pastParticipants.pastParticipants()));
    }

    @SafeVarargs
    private <T> List<T> toSingleList(List<T> ... all) {
        return switch (all.length) {
            case 0 -> List.of();
            case 1 -> all[0];
            default -> Stream.of(all).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        };
    }

    private void attributeSender(ChatMessageInfo info, Jid senderJid) {
        if (senderJid.server() != JidServer.WHATSAPP && senderJid.server() != JidServer.USER) {
            return;
        }
        Contact contact = this.socketHandler.store().findContactByJid(senderJid).orElseGet(() -> this.socketHandler.store().addContact(new Contact(senderJid)));
        info.setSender(contact);
    }

    private void attributeContext(ContextInfo contextInfo) {
        contextInfo.quotedMessageSenderJid().ifPresent(senderJid -> this.attributeContextSender(contextInfo, (Jid)senderJid));
        contextInfo.quotedMessageChatJid().ifPresent(chatJid -> this.attributeContextChat(contextInfo, (Jid)chatJid));
    }

    private void attributeContextChat(ContextInfo contextInfo, Jid chatJid) {
        Chat chat = this.socketHandler.store().findChatByJid(chatJid).orElseGet(() -> this.socketHandler.store().addNewChat(chatJid));
        contextInfo.setQuotedMessageChat(chat);
    }

    private void attributeContextSender(ContextInfo contextInfo, Jid senderJid) {
        Contact contact = this.socketHandler.store().findContactByJid(senderJid).orElseGet(() -> this.socketHandler.store().addContact(new Contact(senderJid)));
        contextInfo.setQuotedMessageSender(contact);
    }

    protected ChatMessageInfo attributeChatMessage(ChatMessageInfo info) {
        Chat chat = this.socketHandler.store().findChatByJid(info.chatJid()).orElseGet(() -> this.socketHandler.store().addNewChat(info.chatJid()));
        info.setChat(chat);
        Jid me = this.socketHandler.store().jid().orElse(null);
        if (info.fromMe() && me != null) {
            info.key().setSenderJid(me.withoutDevice());
        }
        this.attributeSender(info, info.senderJid());
        info.message().contentWithContext().flatMap(ContextualMessage::contextInfo).ifPresent(this::attributeContext);
        this.processMessageWithSecret(info);
        return info;
    }

    private void processMessageWithSecret(ChatMessageInfo info) {
        Message message = info.message().content();
        Objects.requireNonNull(message);
        Message message2 = message;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PollCreationMessage.class, PollUpdateMessage.class, ReactionMessage.class}, (Object)message2, n)) {
            case 0: {
                PollCreationMessage pollCreationMessage = (PollCreationMessage)message2;
                this.handlePollCreation(info, pollCreationMessage);
                break;
            }
            case 1: {
                PollUpdateMessage pollUpdateMessage = (PollUpdateMessage)message2;
                this.handlePollUpdate(info, pollUpdateMessage);
                break;
            }
            case 2: {
                ReactionMessage reactionMessage = (ReactionMessage)message2;
                this.handleReactionMessage(info, reactionMessage);
                break;
            }
        }
    }

    private void handlePollCreation(ChatMessageInfo info, PollCreationMessage pollCreationMessage) {
        if (pollCreationMessage.encryptionKey().isPresent()) {
            return;
        }
        info.message().deviceInfo().flatMap(DeviceContextInfo::messageSecret).or(info::messageSecret).ifPresent(pollCreationMessage::setEncryptionKey);
    }

    private void handlePollUpdate(ChatMessageInfo info, PollUpdateMessage pollUpdateMessage) {
        Optional<ChatMessageInfo> originalPollInfo = this.socketHandler.store().findMessageByKey(pollUpdateMessage.pollCreationMessageKey());
        if (originalPollInfo.isEmpty()) {
            return;
        }
        Message message = originalPollInfo.get().message().content();
        if (!(message instanceof PollCreationMessage)) {
            return;
        }
        PollCreationMessage originalPollMessage = (PollCreationMessage)message;
        pollUpdateMessage.setPollCreationMessage(originalPollMessage);
        byte[] originalPollSender = originalPollInfo.get().senderJid().withoutDevice().toString().getBytes(StandardCharsets.UTF_8);
        Jid modificationSenderJid = info.senderJid().withoutDevice();
        pollUpdateMessage.setVoter(modificationSenderJid);
        byte[] modificationSender = modificationSenderJid.toString().getBytes(StandardCharsets.UTF_8);
        byte[] secretName = pollUpdateMessage.secretName().getBytes(StandardCharsets.UTF_8);
        byte[] useSecretPayload = BytesHelper.concat(originalPollInfo.get().id().getBytes(StandardCharsets.UTF_8), originalPollSender, modificationSender, secretName);
        byte[] encryptionKey = originalPollMessage.encryptionKey().orElseThrow(() -> new NoSuchElementException("Missing encryption key"));
        byte[] useCaseSecret = Hkdf.extractAndExpand(encryptionKey, useSecretPayload, 32);
        String additionalData = "%s\u0000%s".formatted(originalPollInfo.get().id(), modificationSenderJid);
        PollUpdateEncryptedMetadata metadata = pollUpdateMessage.encryptedMetadata().orElseThrow(() -> new NoSuchElementException("Missing encrypted metadata"));
        byte[] decrypted = AesGcm.decrypt(metadata.iv(), metadata.payload(), useCaseSecret, additionalData.getBytes(StandardCharsets.UTF_8));
        PollUpdateEncryptedOptions pollVoteMessage = PollUpdateEncryptedOptionsSpec.decode(decrypted);
        List<PollOption> selectedOptions = pollVoteMessage.selectedOptions().stream().map(sha256 -> originalPollMessage.getSelectableOption(HexFormat.of().formatHex((byte[])sha256))).flatMap(Optional::stream).toList();
        originalPollMessage.addSelectedOptions(modificationSenderJid, selectedOptions);
        pollUpdateMessage.setVotes(selectedOptions);
        PollUpdate update = new PollUpdate(info.key(), pollVoteMessage, Clock.nowMilliseconds());
        info.pollUpdates().add(update);
    }

    private void handleReactionMessage(ChatMessageInfo info, ReactionMessage reactionMessage) {
        info.setIgnore(true);
        this.socketHandler.store().findMessageByKey(reactionMessage.key()).ifPresent(message -> message.reactions().add(reactionMessage));
    }

    protected void dispose() {
        this.historyCache.clear();
        this.historySyncTask = null;
        this.historySyncTypes.clear();
    }

    private record MessageDecodeResult(byte[] message, Throwable error) {
        public boolean hasError() {
            return this.error != null;
        }
    }
}

