/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.WebVerificationSupport;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.binary.BinaryDecoder;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.StoreKeysPair;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatSettingPolicy;
import it.auties.whatsapp.model.chat.GroupMetadata;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.chat.GroupSetting;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoBuilder;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.info.QuotedMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeyBuilder;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.response.ContactAboutResponse;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.signal.auth.ClientHello;
import it.auties.whatsapp.model.signal.auth.ClientHelloBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageSpec;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.model.sync.PrimaryFeature;
import it.auties.whatsapp.socket.AppStateHandler;
import it.auties.whatsapp.socket.AuthHandler;
import it.auties.whatsapp.socket.MessageHandler;
import it.auties.whatsapp.socket.SocketListener;
import it.auties.whatsapp.socket.SocketRequest;
import it.auties.whatsapp.socket.SocketSession;
import it.auties.whatsapp.socket.SocketState;
import it.auties.whatsapp.socket.StreamHandler;
import it.auties.whatsapp.util.Clock;
import java.net.SocketException;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;

public class SocketHandler
implements SocketListener {
    private static final ExecutorService DEFAULT_EXECUTOR = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : Executors.newSingleThreadExecutor();
    private static final Set<UUID> connectedUuids = ConcurrentHashMap.newKeySet();
    private static final Set<Long> connectedPhoneNumbers = ConcurrentHashMap.newKeySet();
    private static final Set<String> connectedAlias = ConcurrentHashMap.newKeySet();
    private SocketSession session;
    private final Whatsapp whatsapp;
    private final AuthHandler authHandler;
    private final StreamHandler streamHandler;
    private final MessageHandler messageHandler;
    private final AppStateHandler appStateHandler;
    private final ErrorHandler errorHandler;
    private final ExecutorService socketExecutor;
    private volatile SocketState state;
    private Keys keys;
    private Store store;
    private Thread shutdownHook;
    private ExecutorService listenersService;

    public static boolean isConnected(UUID uuid) {
        return connectedUuids.contains(uuid);
    }

    public static boolean isConnected(long phoneNumber) {
        return connectedPhoneNumbers.contains(phoneNumber);
    }

    public static boolean isConnected(String id) {
        return connectedAlias.contains(id);
    }

    public SocketHandler(Whatsapp whatsapp, Store store, Keys keys, ErrorHandler errorHandler, WebVerificationSupport webVerificationSupport, ExecutorService socketExecutor) {
        this.whatsapp = whatsapp;
        this.store = store;
        this.keys = keys;
        this.state = SocketState.WAITING;
        this.authHandler = new AuthHandler(this);
        this.streamHandler = new StreamHandler(this, webVerificationSupport);
        this.messageHandler = new MessageHandler(this);
        this.appStateHandler = new AppStateHandler(this);
        this.errorHandler = Objects.requireNonNullElse(errorHandler, ErrorHandler.toTerminal());
        this.socketExecutor = Objects.requireNonNullElse(socketExecutor, DEFAULT_EXECUTOR);
    }

    private void onShutdown(boolean reconnect) {
        if (this.state != SocketState.LOGGED_OUT && this.state != SocketState.RESTORE) {
            this.keys.dispose();
            this.store.dispose();
        }
        if (!reconnect) {
            this.dispose();
        }
    }

    protected void onSocketEvent(SocketEvent event) {
        this.callListenersAsync(listener -> {
            listener.onSocketEvent(this.whatsapp, event);
            listener.onSocketEvent(event);
        });
    }

    private void callListenersAsync(Consumer<Listener> consumer) {
        ExecutorService service = this.getOrCreateListenersService();
        this.store.listeners().forEach(listener -> service.execute(() -> this.invokeListenerSafe(consumer, (Listener)listener)));
    }

    @Override
    public void onOpen(SocketSession session) {
        this.session = session;
        if (this.state == SocketState.CONNECTED) {
            return;
        }
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(() -> this.onShutdown(false));
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        this.markConnected();
        this.state = SocketState.WAITING;
        this.onSocketEvent(SocketEvent.OPEN);
        ClientHello clientHello = new ClientHelloBuilder().ephemeral(this.keys.ephemeralKeyPair().publicKey()).build();
        HandshakeMessage handshakeMessage = new HandshakeMessageBuilder().clientHello(clientHello).build();
        SocketRequest.of(HandshakeMessageSpec.encode(handshakeMessage)).sendWithPrologue(session, this.keys, this.store).exceptionallyAsync(throwable -> (Node)this.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
    }

    protected void markConnected() {
        connectedUuids.add(this.store.uuid());
        this.store.phoneNumber().map(PhoneNumber::number).ifPresent(connectedPhoneNumbers::add);
        connectedAlias.addAll(this.store.alias());
    }

    @Override
    public void onMessage(byte[] message) {
        if (this.state != SocketState.CONNECTED && this.state != SocketState.RESTORE) {
            ((CompletableFuture)this.authHandler.login(this.session, message).thenApplyAsync(result -> result != false ? this.setState(SocketState.CONNECTED) : null)).exceptionallyAsync(throwable -> (SocketHandler)this.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
            return;
        }
        Optional<byte[]> readKey = this.keys.readKey();
        if (readKey.isEmpty()) {
            return;
        }
        byte[] decipheredMessage = this.decipherMessage(message, readKey.get());
        if (decipheredMessage == null) {
            return;
        }
        try (BinaryDecoder decoder = new BinaryDecoder(decipheredMessage);){
            Node node = decoder.decode();
            this.onNodeReceived(node);
            this.store.resolvePendingRequest(node, false);
            this.streamHandler.digest(node);
        }
        catch (Throwable throwable2) {
            this.handleFailure(ErrorHandler.Location.STREAM, throwable2);
        }
    }

    private byte[] decipherMessage(byte[] message, byte[] readKey) {
        try {
            return AesGcm.decrypt(this.keys.readCounter(true), message, readKey);
        }
        catch (Throwable throwable) {
            return (byte[])this.handleFailure(ErrorHandler.Location.CRYPTOGRAPHY, throwable);
        }
    }

    private void onNodeReceived(Node deciphered) {
        this.callListenersAsync(listener -> {
            listener.onNodeReceived(this.whatsapp, deciphered);
            listener.onNodeReceived(deciphered);
        });
    }

    @Override
    public void onClose() {
        if (this.state == SocketState.CONNECTED) {
            this.disconnect(DisconnectReason.RECONNECTING);
            return;
        }
        this.onDisconnected(this.state.toReason());
        this.onShutdown(this.state == SocketState.RECONNECTING);
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.isIgnorableSocketError(throwable)) {
            return;
        }
        this.onSocketEvent(SocketEvent.ERROR);
        this.handleFailure(ErrorHandler.Location.UNKNOWN, throwable);
    }

    private boolean isIgnorableSocketError(Throwable throwable) {
        SocketException socketException;
        return throwable instanceof SocketException && Objects.equals((socketException = (SocketException)throwable).getMessage(), "Socket closed") && (this.state() == SocketState.RECONNECTING || this.state() == SocketState.DISCONNECTED);
    }

    public CompletableFuture<Void> connect() {
        if (this.state == SocketState.CONNECTED) {
            return CompletableFuture.completedFuture(null);
        }
        this.session = SocketSession.of(this.store.proxy().orElse(null), this.socketExecutor, this.store.clientType() == ClientType.WEB);
        return this.session.connect(this);
    }

    public CompletableFuture<Void> disconnect(DisconnectReason reason) {
        SocketState newState = SocketState.of(reason);
        if (this.state == newState) {
            return CompletableFuture.completedFuture(null);
        }
        this.setState(newState);
        this.keys.clearReadWriteKey();
        return switch (reason) {
            default -> throw new MatchException(null, null);
            case DisconnectReason.DISCONNECTED -> {
                if (this.session != null) {
                    this.session.disconnect();
                }
                yield CompletableFuture.completedFuture(null);
            }
            case DisconnectReason.RECONNECTING -> {
                if (this.session != null) {
                    this.session.disconnect();
                }
                yield this.connect();
            }
            case DisconnectReason.LOGGED_OUT -> {
                this.store.deleteSession();
                this.store.resolveAllPendingRequests();
                if (this.session != null) {
                    this.session.disconnect();
                }
                yield CompletableFuture.completedFuture(null);
            }
            case DisconnectReason.RESTORE -> {
                this.store.deleteSession();
                this.store.resolveAllPendingRequests();
                ArrayList<Listener> oldListeners = new ArrayList<Listener>(this.store.listeners());
                if (this.session != null) {
                    this.session.disconnect();
                }
                UUID uuid = UUID.randomUUID();
                Long number = this.store.phoneNumber().map(PhoneNumber::number).orElse(null);
                StoreKeysPair result = this.store.serializer().newStoreKeysPair(uuid, number, this.store.alias(), this.store.clientType());
                this.keys = result.keys();
                this.store = result.store();
                this.store.addListeners(oldListeners);
                yield this.connect();
            }
        };
    }

    public CompletableFuture<Void> pushPatch(PatchRequest request) {
        Jid jid = this.store.jid().orElseThrow(() -> new IllegalStateException("The session isn't connected"));
        return this.appStateHandler.push(jid, List.of(request));
    }

    public CompletableFuture<Void> pushPatches(Jid jid, List<PatchRequest> requests) {
        return this.appStateHandler.push(jid, requests);
    }

    public void pullPatch(PatchType ... patchTypes) {
        this.appStateHandler.pull(patchTypes);
    }

    protected CompletableFuture<Void> pullInitialPatches() {
        return this.appStateHandler.pullInitial();
    }

    public void decodeMessage(Node node, JidProvider chatOverride, boolean notify) {
        this.messageHandler.decode(node, chatOverride, notify);
    }

    public CompletableFuture<Void> sendPeerMessage(Jid companion, ProtocolMessage message) {
        if (message == null) {
            return CompletableFuture.completedFuture(null);
        }
        Jid jid = this.store.jid().orElseThrow(() -> new IllegalStateException("The session isn't connected"));
        ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId()).chatJid(companion).fromMe(true).senderJid(jid).build();
        ChatMessageInfo info = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).senderJid(jid).key(key).message(MessageContainer.of(message)).timestampSeconds(Clock.nowSeconds()).build();
        MessageSendRequest.Chat request = new MessageSendRequest.Chat(info, null, false, true, null);
        return this.sendMessage(request);
    }

    public CompletableFuture<Void> sendMessage(MessageSendRequest request) {
        return this.messageHandler.encode(request);
    }

    public CompletableFuture<Void> sendQueryWithNoResponse(String method, String category, Node ... body) {
        return this.sendQueryWithNoResponse(null, JidServer.WHATSAPP.toJid(), method, category, null, body);
    }

    public CompletableFuture<Void> sendQueryWithNoResponse(String id, Jid to, String method, String category, Map<String, Object> metadata, Node ... body) {
        LinkedHashMap<String, Object> attributes = Attributes.ofNullable(metadata).put("id", id, Objects::nonNull).put("type", method).put("to", to).put("xmlns", category, Objects::nonNull).toMap();
        return this.sendWithNoResponse(Node.of("iq", attributes, body));
    }

    public CompletableFuture<Void> sendWithNoResponse(Node node) {
        if (this.state() == SocketState.RESTORE) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)node.toRequest(null, false).sendWithNoResponse(this.session, this.keys, this.store).exceptionallyAsync(throwable -> (Void)this.handleFailure(ErrorHandler.Location.STREAM, (Throwable)throwable))).thenRunAsync(() -> this.onNodeSent(node));
    }

    private void onNodeSent(Node node) {
        this.callListenersAsync(listener -> {
            listener.onNodeSent(this.whatsapp, node);
            listener.onNodeSent(node);
        });
    }

    public CompletableFuture<Optional<ContactAboutResponse>> queryAbout(JidProvider chat) {
        Node query = Node.of("status");
        Node body = Node.of("user", Map.of("jid", chat.toJid()));
        return this.sendInteractiveQuery(query, body).thenApplyAsync(this::parseAbout);
    }

    public CompletableFuture<List<Node>> sendInteractiveQuery(Node queryNode, Node ... queryBody) {
        Node query = Node.of("query", (Object)queryNode);
        Node list = Node.of("list", queryBody);
        Node sync = Node.of("usync", Map.of("sid", ChatMessageKey.randomId(), "mode", "query", "last", "true", "index", "0", "context", "interactive"), query, list);
        return this.sendQuery("get", "usync", sync).thenApplyAsync(this::parseQueryResult);
    }

    private Optional<ContactAboutResponse> parseAbout(List<Node> responses) {
        return responses.stream().map(entry -> entry.findNode("status")).flatMap(Optional::stream).findFirst().map(ContactAboutResponse::ofNode);
    }

    public CompletableFuture<Node> sendQuery(String method, String category, Node ... body) {
        return this.sendQuery(null, JidServer.WHATSAPP.toJid(), method, category, null, body);
    }

    private List<Node> parseQueryResult(Node result) {
        return result.findNodes("usync").stream().map(node -> node.findNode("list")).flatMap(Optional::stream).map(node -> node.findNodes("user")).flatMap(Collection::stream).toList();
    }

    public CompletableFuture<Node> sendQuery(String id, Jid to, String method, String category, Map<String, Object> metadata, Node ... body) {
        LinkedHashMap<String, Object> attributes = Attributes.ofNullable(metadata).put("xmlns", category, Objects::nonNull).put("id", id, Objects::nonNull).put("to", to).put("type", method).toMap();
        return this.send(Node.of("iq", attributes, body));
    }

    public CompletableFuture<Node> send(Node node) {
        return this.send(node, null);
    }

    public CompletableFuture<Node> send(SocketRequest request) {
        return request.send(this.session, this.keys, this.store);
    }

    public CompletableFuture<Node> send(Node node, Function<Node, Boolean> filter) {
        if (this.state() == SocketState.RESTORE) {
            return CompletableFuture.completedFuture(node);
        }
        SocketRequest request = node.toRequest(filter, true);
        CompletableFuture<Node> result = request.send(this.session, this.keys, this.store);
        this.onNodeSent(node);
        return result;
    }

    public CompletableFuture<Optional<URI>> queryPicture(JidProvider chat) {
        Node body = Node.of("picture", Map.of("query", "url", "type", "image"));
        if (chat.toJid().hasServer(JidServer.GROUP)) {
            return ((CompletableFuture)this.queryGroupMetadata(chat.toJid()).thenComposeAsync(result -> this.sendQuery("get", "w:profile:picture", Map.of(result.isCommunity() ? "parent_group_jid" : "target", chat.toJid()), body))).thenApplyAsync(this::parseChatPicture);
        }
        return this.sendQuery("get", "w:profile:picture", Map.of("target", chat.toJid()), body).thenApplyAsync(this::parseChatPicture);
    }

    public CompletableFuture<Node> sendQuery(String method, String category, Map<String, Object> metadata, Node ... body) {
        return this.sendQuery(null, JidServer.WHATSAPP.toJid(), method, category, metadata, body);
    }

    private Optional<URI> parseChatPicture(Node result) {
        return result.findNode("picture").flatMap(picture -> picture.attributes().getOptionalString("url")).map(URI::create);
    }

    public CompletableFuture<List<Jid>> queryBlockList() {
        return this.sendQuery("get", "blocklist", new Node[]{null}).thenApplyAsync(this::parseBlockList);
    }

    private List<Jid> parseBlockList(Node result) {
        return result.findNode("list").orElseThrow(() -> new NoSuchElementException("Missing block list in newsletters")).findNodes("item").stream().map(item -> item.attributes().getOptionalJid("jid")).flatMap(Optional::stream).toList();
    }

    public CompletableFuture<Void> subscribeToPresence(JidProvider jid) {
        Node node = Node.of("presence", Map.of("to", jid.toJid(), "type", "subscribe"));
        return this.sendWithNoResponse(node);
    }

    public CompletableFuture<OptionalLong> subscribeToNewsletterReactions(JidProvider channel) {
        return this.sendQuery(channel.toJid(), "set", "newsletter", Node.of("live_updates")).thenApplyAsync(this::parseNewsletterSubscription);
    }

    private OptionalLong parseNewsletterSubscription(Node result) {
        return result.findNode("live_updates").stream().map(node -> node.attributes().getOptionalLong("duration")).flatMapToLong(OptionalLong::stream).findFirst();
    }

    public CompletableFuture<Void> queryNewsletterMessages(JidProvider newsletterJid, int count) {
        Newsletter newsletter = this.store.findNewsletterByJid(newsletterJid).orElseThrow(() -> new NoSuchElementException("Missing newsletter"));
        String newsletterInvite = newsletter.metadata().invite().orElseThrow(() -> new NoSuchElementException("Missing newsletter key"));
        return this.sendQuery("get", "newsletter", Node.of("messages", Map.of("count", count, "type", "invite", "key", newsletterInvite))).thenAcceptAsync(result -> this.onNewsletterMessages(newsletter, (Node)result));
    }

    private void onNewsletterMessages(Newsletter newsletter, Node result) {
        result.findNode("messages").stream().map(messages -> messages.findNodes("message")).flatMap(Collection::stream).forEach(messages -> this.decodeMessage((Node)messages, newsletter, false));
    }

    public CompletableFuture<GroupMetadata> queryGroupMetadata(JidProvider group) {
        Node body = Node.of("query", Map.of("request", "interactive"));
        return this.sendQuery(group.toJid(), "get", "w:g2", body).thenApplyAsync(this::handleGroupMetadata);
    }

    protected GroupMetadata handleGroupMetadata(Node response) {
        GroupMetadata metadata = Optional.of(response).filter(entry -> entry.hasDescription("group")).or(() -> response.findNode("group")).map(this::parseGroupMetadata).orElseThrow(() -> new NoSuchElementException("Erroneous response: %s".formatted(response)));
        Chat chat = this.store.findChatByJid(metadata.jid()).orElseGet(() -> this.store().addNewChat(metadata.jid()));
        if (chat != null) {
            metadata.foundationTimestamp().ifPresent(timestamp -> chat.setFoundationTimestampSeconds(timestamp.toEpochSecond()));
            metadata.founder().ifPresent(chat::setFounder);
            metadata.description().ifPresent(chat::setDescription);
            chat.addParticipants(metadata.participants());
        }
        return metadata;
    }

    public GroupMetadata parseGroupMetadata(Node node) {
        Jid groupId = node.attributes().getOptionalString("id").map(id -> Jid.of(id, JidServer.GROUP)).orElseThrow(() -> new NoSuchElementException("Missing group jid"));
        String subject = node.attributes().getString("subject");
        Optional<Jid> subjectAuthor = node.attributes().getOptionalJid("s_o");
        long subjectTimestampSeconds = node.attributes().getOptionalLong("s_t").orElse(0L);
        long foundationTimestampSeconds = node.attributes().getOptionalLong("creation").orElse(0L);
        Optional<Jid> founder = node.attributes().getOptionalJid("creator");
        HashMap<GroupSetting, ChatSettingPolicy> policies = new HashMap<GroupSetting, ChatSettingPolicy>();
        policies.put(GroupSetting.SEND_MESSAGES, ChatSettingPolicy.of(node.hasNode("restrict")));
        policies.put(GroupSetting.EDIT_GROUP_INFO, ChatSettingPolicy.of(node.hasNode("announce")));
        policies.put(GroupSetting.APPROVE_PARTICIPANTS, ChatSettingPolicy.of(node.hasNode("membership_approval_mode")));
        Optional<String> description = node.findNode("description").flatMap(parent -> parent.findNode("body")).flatMap(Node::contentAsString);
        Optional<String> descriptionId = node.findNode("description").map(Node::attributes).flatMap(attributes -> attributes.getOptionalString("id"));
        boolean community = node.findNode("parent").isPresent();
        boolean openCommunity = node.findNode("parent").filter(entry -> entry.attributes().hasValue("default_membership_approval_mode", "request_required")).isEmpty();
        Optional<ZonedDateTime> ephemeral = node.findNode("ephemeral").map(Node::attributes).map(attributes -> attributes.getLong("expiration")).flatMap(Clock::parseSeconds);
        List<GroupParticipant> participants = node.findNodes("participant").stream().map(this::parseGroupParticipant).toList();
        return new GroupMetadata(groupId, subject, subjectAuthor, Clock.parseSeconds(subjectTimestampSeconds), Clock.parseSeconds(foundationTimestampSeconds), founder, description, descriptionId, Collections.unmodifiableMap(policies), participants, ephemeral, community, openCommunity);
    }

    private GroupParticipant parseGroupParticipant(Node node) {
        Jid id = node.attributes().getRequiredJid("jid");
        GroupRole role = GroupRole.of(node.attributes().getString("type", null));
        return new GroupParticipant(id, role);
    }

    public CompletableFuture<Node> sendQuery(Jid to, String method, String category, Node ... body) {
        return this.sendQuery(null, to, method, category, null, body);
    }

    public CompletableFuture<Void> sendReceipt(Jid jid, Jid participant, List<String> messages, String type) {
        if (messages.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Attributes attributes = Attributes.of(new Map.Entry[0]).put("id", messages.getFirst()).put("t", (Object)Clock.nowMilliseconds(), () -> Objects.equals(type, "read") || Objects.equals(type, "read-self")).put("to", jid).put("type", type, Objects::nonNull);
        if (Objects.equals(type, "sender") && jid.hasServer(JidServer.WHATSAPP)) {
            attributes.put("recipient", jid);
            attributes.put("to", participant);
        } else {
            attributes.put("to", jid);
            attributes.put("participant", participant, Objects::nonNull);
        }
        Node receipt = Node.of("receipt", attributes.toMap(), this.toMessagesNode(messages));
        return this.sendWithNoResponse(receipt);
    }

    private List<Node> toMessagesNode(List<String> messages) {
        if (messages.size() <= 1) {
            return null;
        }
        return messages.subList(1, messages.size()).stream().map(id -> Node.of("item", Map.of("id", id))).toList();
    }

    protected CompletableFuture<Void> sendMessageAck(Jid from, Node node) {
        Attributes attrs = node.attributes();
        String type = attrs.getOptionalString("type").filter(entry -> !Objects.equals(entry, "message")).orElse(null);
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", node.id()).put("to", from).put("class", node.description()).put("participant", attrs.getNullableString("participant"), Objects::nonNull).put("recipient", attrs.getNullableString("recipient"), Objects::nonNull).put("type", type, Objects::nonNull).toMap();
        return this.sendWithNoResponse(Node.of("ack", attributes));
    }

    protected void onRegistrationCode(long code) {
        this.callListenersAsync(listener -> {
            listener.onRegistrationCode(this.whatsapp, code);
            listener.onRegistrationCode(code);
        });
    }

    protected void onMetadata(Map<String, String> properties) {
        this.callListenersAsync(listener -> {
            listener.onMetadata(this.whatsapp, properties);
            listener.onMetadata(properties);
        });
    }

    protected void onMessageStatus(MessageInfo message) {
        this.callListenersAsync(listener -> {
            listener.onMessageStatus(this.whatsapp, message);
            listener.onMessageStatus(message);
        });
    }

    protected void onUpdateChatPresence(ContactStatus status, Jid jid, Chat chat) {
        Optional<Contact> contact = this.store.findContactByJid(jid);
        if (contact.isPresent()) {
            contact.get().setLastKnownPresence(status);
            contact.get().setLastSeen(ZonedDateTime.now());
        }
        chat.presences().put(jid, status);
        this.callListenersAsync(listener -> {
            listener.onContactPresence(this.whatsapp, chat, jid, status);
            listener.onContactPresence(chat, jid, status);
        });
    }

    protected void onNewMessage(ChatMessageInfo info) {
        this.callListenersAsync(listener -> {
            listener.onNewMessage(this.whatsapp, info);
            listener.onNewMessage(info);
        });
    }

    protected void onNewStatus(ChatMessageInfo info) {
        this.callListenersAsync(listener -> {
            listener.onNewStatus(this.whatsapp, info);
            listener.onNewStatus(info);
        });
    }

    protected void onChatRecentMessages(Chat chat, boolean last) {
        this.callListenersAsync(listener -> {
            listener.onChatMessagesSync(this.whatsapp, chat, last);
            listener.onChatMessagesSync(chat, last);
        });
    }

    protected void onFeatures(PrimaryFeature features) {
        this.callListenersAsync(listener -> {
            listener.onFeatures(this.whatsapp, features.flags());
            listener.onFeatures(features.flags());
        });
    }

    protected void onSetting(Setting setting) {
        this.callListenersAsync(listener -> {
            listener.onSetting(this.whatsapp, setting);
            listener.onSetting(setting);
        });
    }

    protected void onMessageDeleted(ChatMessageInfo message, boolean everyone) {
        this.callListenersAsync(listener -> {
            listener.onMessageDeleted(this.whatsapp, message, everyone);
            listener.onMessageDeleted(message, everyone);
        });
    }

    protected void onAction(Action action, MessageIndexInfo indexInfo) {
        this.callListenersAsync(listener -> {
            listener.onAction(this.whatsapp, action, indexInfo);
            listener.onAction(action, indexInfo);
        });
    }

    protected void onDisconnected(DisconnectReason loggedOut) {
        if (loggedOut != DisconnectReason.RECONNECTING) {
            connectedUuids.remove(this.store.uuid());
            this.store.phoneNumber().map(PhoneNumber::number).ifPresent(connectedPhoneNumbers::remove);
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        this.callListenersSync(listener -> {
            listener.onDisconnected(this.whatsapp, loggedOut);
            listener.onDisconnected(loggedOut);
        });
    }

    protected void onLoggedIn() {
        this.callListenersAsync(listener -> {
            listener.onLoggedIn(this.whatsapp);
            listener.onLoggedIn();
        });
    }

    public void callListenersSync(Consumer<Listener> consumer) {
        ExecutorService service = this.getOrCreateListenersService();
        CompletableFuture[] futures = (CompletableFuture[])this.store.listeners().stream().map(listener -> CompletableFuture.runAsync(() -> this.invokeListenerSafe(consumer, (Listener)listener), service)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
    }

    private void invokeListenerSafe(Consumer<Listener> consumer, Listener listener) {
        try {
            consumer.accept(listener);
        }
        catch (Throwable throwable) {
            this.handleFailure(ErrorHandler.Location.UNKNOWN, throwable);
        }
    }

    protected void onChats() {
        this.callListenersAsync(listener -> {
            listener.onChats(this.whatsapp, this.store().chats());
            listener.onChats(this.store().chats());
        });
    }

    protected void onNewsletters() {
        this.callListenersAsync(listener -> {
            listener.onNewsletters(this.whatsapp, this.store().newsletters());
            listener.onNewsletters(this.store().newsletters());
        });
    }

    protected void onNewsletterMessage(NewsletterMessageInfo messageInfo) {
        this.callListenersAsync(listener -> {
            listener.onNewMessage(this.whatsapp, messageInfo);
            listener.onNewMessage(messageInfo);
        });
    }

    protected void onStatus() {
        this.callListenersAsync(listener -> {
            listener.onStatus(this.whatsapp, this.store().status());
            listener.onStatus(this.store().status());
        });
    }

    protected void onContacts() {
        this.callListenersAsync(listener -> {
            listener.onContacts(this.whatsapp, this.store().contacts());
            listener.onContacts(this.store().contacts());
        });
    }

    protected void onHistorySyncProgress(Integer progress, boolean recent) {
        this.callListenersAsync(listener -> {
            listener.onHistorySyncProgress(this.whatsapp, progress, recent);
            listener.onHistorySyncProgress(progress, recent);
        });
    }

    protected void onReply(ChatMessageInfo info) {
        QuotedMessageInfo quoted = info.quotedMessage().orElse(null);
        if (quoted == null) {
            return;
        }
        this.store.resolvePendingReply(info);
        this.callListenersAsync(listener -> {
            listener.onMessageReply(this.whatsapp, info, quoted);
            listener.onMessageReply(info, quoted);
        });
    }

    protected void onGroupPictureChanged(Chat fromChat) {
        this.callListenersAsync(listener -> {
            listener.onGroupPictureChanged(this.whatsapp, fromChat);
            listener.onGroupPictureChanged(fromChat);
        });
    }

    protected void onContactPictureChanged(Contact fromContact) {
        this.callListenersAsync(listener -> {
            listener.onProfilePictureChanged(this.whatsapp, fromContact);
            listener.onProfilePictureChanged(fromContact);
        });
    }

    protected void onUserAboutChanged(String newAbout, String oldAbout) {
        this.callListenersAsync(listener -> {
            listener.onAboutChanged(this.whatsapp, oldAbout, newAbout);
            listener.onAboutChanged(oldAbout, newAbout);
        });
    }

    public void onUserPictureChanged(URI newPicture, URI oldPicture) {
        this.callListenersAsync(listener -> {
            listener.onProfilePictureChanged(this.whatsapp, oldPicture, newPicture);
            listener.onProfilePictureChanged(oldPicture, newPicture);
        });
    }

    public void updateUserName(String newName, String oldName) {
        if (oldName != null && !Objects.equals(newName, oldName)) {
            boolean wasOnline = this.store().online();
            this.sendWithNoResponse(Node.of("presence", Map.of("name", oldName, "type", "unavailable")));
            this.sendWithNoResponse(Node.of("presence", Map.of("name", newName, "type", "available")));
            if (!wasOnline) {
                this.sendWithNoResponse(Node.of("presence", Map.of("name", oldName, "type", "unavailable")));
            }
            this.onUserNameChanged(newName, oldName);
        }
        Jid self = this.store.jid().orElseThrow(() -> new IllegalStateException("The session isn't connected")).withoutDevice();
        this.store().findContactByJid(self).orElseGet(() -> this.store().addContact(self)).setChosenName(newName);
        this.store().setName(newName);
    }

    private void onUserNameChanged(String newName, String oldName) {
        this.callListenersAsync(listener -> {
            listener.onNameChanged(this.whatsapp, oldName, newName);
            listener.onNameChanged(oldName, newName);
        });
    }

    public void updateLocale(CountryLocale newLocale, CountryLocale oldLocale) {
        if (!Objects.equals(newLocale, oldLocale)) {
            return;
        }
        if (oldLocale != null) {
            this.onUserLocaleChanged(newLocale, oldLocale);
        }
        this.store().setLocale(newLocale);
    }

    private void onUserLocaleChanged(CountryLocale newLocale, CountryLocale oldLocale) {
        this.callListenersAsync(listener -> {
            listener.onLocaleChanged(this.whatsapp, oldLocale, newLocale);
            listener.onLocaleChanged(oldLocale, newLocale);
        });
    }

    protected void onContactBlocked(Contact contact) {
        this.callListenersAsync(listener -> {
            listener.onContactBlocked(this.whatsapp, contact);
            listener.onContactBlocked(contact);
        });
    }

    protected void onNewContact(Contact contact) {
        this.callListenersAsync(listener -> {
            listener.onNewContact(this.whatsapp, contact);
            listener.onNewContact(contact);
        });
    }

    protected void onDevices(LinkedHashMap<Jid, Integer> devices) {
        this.callListenersAsync(listener -> {
            listener.onLinkedDevices(this.whatsapp, devices.keySet());
            listener.onLinkedDevices(devices.keySet());
        });
    }

    public void onCall(Call call) {
        this.callListenersAsync(listener -> {
            listener.onCall(this.whatsapp, call);
            listener.onCall(call);
        });
    }

    public void onPrivacySettingChanged(PrivacySettingEntry oldEntry, PrivacySettingEntry newEntry) {
        this.callListenersAsync(listener -> {
            listener.onPrivacySettingChanged(this.whatsapp, oldEntry, newEntry);
            listener.onPrivacySettingChanged(oldEntry, newEntry);
        });
    }

    protected void querySessionsForcefully(Jid jid) {
        this.messageHandler.querySessions(List.of(jid), true);
    }

    private void dispose() {
        this.onSocketEvent(SocketEvent.CLOSE);
        this.streamHandler.dispose();
        this.messageHandler.dispose();
        this.appStateHandler.dispose();
        if (this.listenersService != null) {
            this.listenersService.shutdownNow();
        }
    }

    private ExecutorService getOrCreateListenersService() {
        if (this.listenersService == null || this.listenersService.isShutdown()) {
            this.listenersService = Executors.newCachedThreadPool();
        }
        return this.listenersService;
    }

    protected <T> T handleFailure(ErrorHandler.Location location, Throwable throwable) {
        if (this.state() == SocketState.RESTORE || this.state() == SocketState.LOGGED_OUT) {
            return null;
        }
        ErrorHandler.Result result = this.errorHandler.handleError(this.store.clientType(), location, throwable);
        switch (result) {
            case RESTORE: {
                this.disconnect(DisconnectReason.RESTORE);
                break;
            }
            case LOG_OUT: {
                this.disconnect(DisconnectReason.LOGGED_OUT);
                break;
            }
            case DISCONNECT: {
                this.disconnect(DisconnectReason.DISCONNECTED);
                break;
            }
            case RECONNECT: {
                this.disconnect(DisconnectReason.RECONNECTING);
            }
        }
        return null;
    }

    public CompletableFuture<Void> querySessions(Jid jid) {
        return this.messageHandler.getDevices(List.of(jid), true).thenCompose(values -> this.messageHandler.querySessions((List<Jid>)values, false));
    }

    public void parseSessions(Node result) {
        this.messageHandler.parseSessions(result);
    }

    public CompletableFuture<List<BusinessCategory>> queryBusinessCategories() {
        return this.sendQuery("get", "fb:thrift_iq", Node.of("request", Map.of("op", "profile_typeahead", "type", "catkit", "v", "1"), (Object)Node.of("query", List.of()))).thenApplyAsync(this::parseBusinessCategories);
    }

    private List<BusinessCategory> parseBusinessCategories(Node result) {
        return result.findNode("result").flatMap(entry -> entry.findNode("categories")).stream().map(entry -> entry.findNodes("category")).flatMap(Collection::stream).map(BusinessCategory::of).toList();
    }

    public Whatsapp whatsapp() {
        return this.whatsapp;
    }

    public SocketState state() {
        return this.state;
    }

    public Keys keys() {
        return this.keys;
    }

    public Store store() {
        return this.store;
    }

    protected SocketHandler setState(SocketState state) {
        this.state = state;
        return this;
    }
}

