/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.binary.BinaryEncoder;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.exception.RequestException;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.socket.SocketSession;
import it.auties.whatsapp.util.Exceptions;
import it.auties.whatsapp.util.Specification;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public record SocketRequest(String id, Object body, CompletableFuture<Node> future, Function<Node, Boolean> filter, Throwable caller) {
    private static final int TIMEOUT = 60;
    private static final Executor EXECUTOR = CompletableFuture.delayedExecutor(60L, TimeUnit.SECONDS);

    private SocketRequest(String id, Function<Node, Boolean> filter, Object body) {
        this(id, body, new CompletableFuture<Node>(), filter, SocketRequest.trace(body));
        EXECUTOR.execute(this::cancelTimedFuture);
    }

    private static Throwable trace(Object body) {
        String string;
        Throwable current = Exceptions.current(null);
        StackTraceElement[] actualStackTrace = (StackTraceElement[])Arrays.stream(current.getStackTrace()).filter(entry -> !entry.getClassName().equals(SocketRequest.class.getName()) && !entry.getClassName().equals(Node.class.getName())).toArray(StackTraceElement[]::new);
        current.setStackTrace(actualStackTrace);
        if (body instanceof Node) {
            Node node = (Node)body;
            string = "%s node timed out".formatted(node.toString());
        } else {
            string = "Binary timed out";
        }
        return new RequestException(string, current);
    }

    private void cancelTimedFuture() {
        if (this.future.isDone()) {
            return;
        }
        this.future.completeExceptionally(this.caller);
    }

    public static SocketRequest of(Node body, Function<Node, Boolean> filter) {
        return new SocketRequest(body.id(), filter, body);
    }

    public static SocketRequest of(byte[] body) {
        return new SocketRequest(null, null, body);
    }

    public CompletableFuture<Node> sendWithPrologue(SocketSession session, Keys keys, Store store) {
        return this.send(session, keys, store, true, false);
    }

    public CompletableFuture<Node> send(SocketSession session, Keys keys, Store store, boolean prologue, boolean response) {
        CompletableFuture<Node> completableFuture;
        byte[] ciphered = this.encryptMessage(keys);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            if (prologue) {
                dataOutputStream.write(this.getPrologueData(store));
            }
            dataOutputStream.writeInt(ciphered.length >> 16);
            dataOutputStream.writeShort(0xFFFF & ciphered.length);
            dataOutputStream.write(ciphered);
            ((CompletableFuture)session.sendBinary(byteArrayOutputStream.toByteArray()).thenRunAsync(() -> this.onSendSuccess(store, response))).exceptionallyAsync(this::onSendError);
            completableFuture = this.future;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new RequestException(exception);
            }
        }
        dataOutputStream.close();
        return completableFuture;
    }

    private byte[] getPrologueData(Store store) {
        return switch (store.clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> Specification.Whatsapp.WEB_PROLOGUE;
            case ClientType.MOBILE -> Specification.Whatsapp.MOBILE_PROLOGUE;
        };
    }

    private byte[] encryptMessage(Keys keys) {
        Object encodedBody = this.body();
        byte[] body = this.getBody(encodedBody);
        return keys.writeKey().map(bytes -> AesGcm.encrypt(keys.writeCounter(true), body, bytes)).orElse(body);
    }

    private byte[] getBody(Object encodedBody) {
        Object object = encodedBody;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, Node.class}, (Object)object, n)) {
            case 0 -> {
                byte[] bytes;
                byte[] var4_5;
                yield var4_5 = (bytes = (byte[])object);
            }
            case 1 -> {
                byte[] var4_6;
                Node node = (Node)object;
                BinaryEncoder encoder = new BinaryEncoder();
                try {
                    var4_6 = encoder.encode(node);
                }
                catch (Throwable var8_10) {
                    try {
                        try {
                            encoder.close();
                        }
                        catch (Throwable var9_11) {
                            var8_10.addSuppressed(var9_11);
                        }
                        throw var8_10;
                    }
                    catch (IOException exception) {
                        throw new UncheckedIOException(exception);
                    }
                }
                encoder.close();
                yield var4_6;
            }
            default -> throw new IllegalArgumentException("Cannot create request, illegal body: %s".formatted(encodedBody));
        };
    }

    private void onSendSuccess(Store store, boolean response) {
        if (!response) {
            this.future.complete(null);
            return;
        }
        store.addRequest(this);
    }

    private Void onSendError(Throwable throwable) {
        this.future.completeExceptionally(new IOException("Cannot send %s, an unknown exception occurred".formatted(this), throwable));
        return null;
    }

    public CompletableFuture<Node> send(SocketSession session, Keys keys, Store store) {
        return this.send(session, keys, store, false, true);
    }

    public CompletableFuture<Void> sendWithNoResponse(SocketSession session, Keys keys, Store store) {
        return this.send(session, keys, store, false, false).thenRunAsync(() -> {});
    }

    public boolean complete(Node response, boolean exceptionally) {
        if (response == null) {
            this.future.complete(null);
            return true;
        }
        if (exceptionally) {
            this.future.completeExceptionally(new RuntimeException("Cannot process request %s with %s".formatted(this, response), this.caller));
            return true;
        }
        if (this.filter != null && !this.filter.apply(response).booleanValue()) {
            return false;
        }
        this.future.complete(response);
        return true;
    }
}

