/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.exception.RequestException;
import it.auties.whatsapp.socket.SocketListener;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Specification;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;

public abstract sealed class SocketSession {
    private static final int MESSAGE_LENGTH = 3;
    final URI proxy;
    final ExecutorService executor;
    final ReentrantLock outputLock;
    SocketListener listener;

    private SocketSession(URI proxy, ExecutorService executor) {
        this.proxy = proxy;
        this.executor = executor;
        this.outputLock = new ReentrantLock(true);
    }

    abstract CompletableFuture<Void> connect(SocketListener var1);

    abstract void disconnect();

    public abstract CompletableFuture<Void> sendBinary(byte[] var1);

    abstract boolean isOpen();

    static SocketSession of(URI proxy, ExecutorService executor, boolean webSocket) {
        if (webSocket) {
            return new WebSocketSession(proxy, executor);
        }
        return new RawSocketSession(proxy, executor);
    }

    public static final class WebSocketSession
    extends SocketSession
    implements WebSocket.Listener {
        private WebSocket session;
        private final List<ByteBuffer> inputParts = new ArrayList<ByteBuffer>(5);

        WebSocketSession(URI proxy, ExecutorService executor) {
            super(proxy, executor);
        }

        @Override
        CompletableFuture<Void> connect(SocketListener listener) {
            if (this.isOpen()) {
                return CompletableFuture.completedFuture(null);
            }
            this.listener = listener;
            return HttpClient.newBuilder().executor(this.executor).proxy(ProxySelector.of((InetSocketAddress)ProxyAuthenticator.getProxy(this.proxy).address())).authenticator(new ProxyAuthenticator()).build().newWebSocketBuilder().buildAsync(Specification.Whatsapp.WEB_SOCKET_ENDPOINT, this).thenRun(() -> listener.onOpen(this));
        }

        @Override
        void disconnect() {
            if (!this.isOpen()) {
                return;
            }
            this.session.sendClose(1000, "");
        }

        @Override
        public CompletableFuture<Void> sendBinary(byte[] bytes) {
            this.outputLock.lock();
            return ((CompletableFuture)this.session.sendBinary(ByteBuffer.wrap(bytes), true).thenRun(this.outputLock::unlock)).exceptionally(exception -> {
                this.outputLock.unlock();
                throw new RequestException((Throwable)exception);
            });
        }

        @Override
        boolean isOpen() {
            return this.session != null && !this.session.isInputClosed() && !this.session.isOutputClosed();
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            this.session = webSocket;
            WebSocket.Listener.super.onOpen(webSocket);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            this.inputParts.clear();
            this.listener.onClose();
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            this.listener.onError(error);
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            this.inputParts.add(data);
            if (!last) {
                return WebSocket.Listener.super.onBinary(webSocket, data, false);
            }
            int inputPartsCounter = 0;
            int length = 0;
            int written = 0;
            byte[] result = null;
            while (inputPartsCounter < this.inputParts.size()) {
                ByteBuffer inputPart = this.inputParts.get(inputPartsCounter);
                if (length <= 0) {
                    if (inputPart.remaining() >= 3) {
                        length = inputPart.get() << 16 | Short.toUnsignedInt(inputPart.getShort());
                    }
                    if (length <= 0) break;
                    result = new byte[length];
                }
                int inputPartSize = inputPart.remaining();
                int readLength = Math.min(inputPartSize, length);
                inputPart.get(result, written, readLength);
                if (inputPart.remaining() < 3) {
                    ++inputPartsCounter;
                }
                written += readLength;
                if ((length -= readLength) > 0) continue;
                try {
                    this.listener.onMessage(result);
                }
                catch (Throwable throwable) {
                    this.listener.onError(throwable);
                }
                written = 0;
                result = null;
            }
            this.inputParts.clear();
            return WebSocket.Listener.super.onBinary(webSocket, data, true);
        }
    }

    static final class RawSocketSession
    extends SocketSession {
        private AsynchronousSocketChannel socket;
        private boolean closed;

        RawSocketSession(URI proxy, ExecutorService executor) {
            super(proxy, executor);
        }

        @Override
        CompletableFuture<Void> connect(SocketListener listener) {
            this.listener = listener;
            if (this.isOpen()) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            try {
                this.socket = AsynchronousSocketChannel.open(AsynchronousChannelGroup.withThreadPool(this.executor));
                this.socket.connect(new InetSocketAddress("g.whatsapp.net", 443), null, new ConnectionHandler(future));
            }
            catch (IOException exception) {
                future.completeExceptionally(exception);
            }
            return future;
        }

        private void readNextMessage() {
            if (!this.isOpen()) {
                this.disconnect();
                return;
            }
            ByteBuffer buffer = ByteBuffer.allocate(3);
            this.socket.read(buffer, null, new MessageLengthHandler(buffer));
        }

        @Override
        void disconnect() {
            if (this.closed) {
                return;
            }
            try {
                this.socket.close();
                this.closed = true;
                this.socket = null;
                this.listener.onClose();
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
            }
            catch (IOException exception) {
                this.listener.onError(exception);
            }
        }

        @Override
        public boolean isOpen() {
            return this.socket != null && this.socket.isOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Void> sendBinary(byte[] bytes) {
            try {
                this.outputLock.lock();
                if (this.socket == null) {
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                this.socket.write(ByteBuffer.wrap(bytes));
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            catch (Throwable throwable) {
                CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(throwable);
                return completableFuture;
            }
            finally {
                this.outputLock.unlock();
            }
        }

        static {
            Authenticator.setDefault(new ProxyAuthenticator());
        }

        private class ConnectionHandler
        implements CompletionHandler<Void, Void> {
            private final CompletableFuture<Void> future;

            private ConnectionHandler(CompletableFuture<Void> future) {
                this.future = future;
            }

            @Override
            public void completed(Void result, Void attachment) {
                RawSocketSession.this.listener.onOpen(RawSocketSession.this);
                RawSocketSession.this.executor.execute(RawSocketSession.this::readNextMessage);
                this.future.complete(null);
            }

            @Override
            public void failed(Throwable throwable, Void attachment) {
                this.future.completeExceptionally(throwable);
            }
        }

        private class MessageLengthHandler
        implements CompletionHandler<Integer, Void> {
            private final ByteBuffer lengthBuffer;

            private MessageLengthHandler(ByteBuffer lengthBuffer) {
                this.lengthBuffer = lengthBuffer;
            }

            @Override
            public void completed(Integer bytesRead, Void attachment) {
                this.lengthBuffer.flip();
                int length = this.lengthBuffer.get() << 16 | Short.toUnsignedInt(this.lengthBuffer.getShort());
                this.lengthBuffer.clear();
                if (length < 0) {
                    return;
                }
                ByteBuffer messageBuffer = ByteBuffer.allocate(length);
                RawSocketSession.this.socket.read(messageBuffer, null, new MessageValueHandler(messageBuffer));
            }

            @Override
            public void failed(Throwable throwable, Void attachment) {
                RawSocketSession.this.listener.onError(throwable);
            }
        }

        private class MessageValueHandler
        implements CompletionHandler<Integer, Void> {
            private final ByteBuffer messageBuffer;

            private MessageValueHandler(ByteBuffer messageBuffer) {
                this.messageBuffer = messageBuffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer bytesRead, Void attachment) {
                try {
                    RawSocketSession.this.listener.onMessage(this.messageBuffer.array());
                    RawSocketSession.this.readNextMessage();
                }
                catch (Throwable throwable) {
                    RawSocketSession.this.listener.onError(throwable);
                }
                finally {
                    this.messageBuffer.clear();
                }
            }

            @Override
            public void failed(Throwable throwable, Void attachment) {
                RawSocketSession.this.listener.onError(throwable);
            }
        }
    }
}

