/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ConcurrentLinkedHashedDequeue<E>
extends AbstractQueue<E>
implements Deque<E> {
    private final AtomicReference<Node<E>> head = new AtomicReference<Object>(null);
    private final AtomicReference<Node<E>> tail = new AtomicReference<Object>(null);
    private final Set<Integer> hashes = ConcurrentHashMap.newKeySet();

    @Override
    public void push(E e) {
        this.add(e);
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.add(e);
    }

    @Override
    public void addLast(E message) {
        this.add(message);
    }

    @Override
    public boolean add(E e) {
        int hash = Objects.hashCode(e);
        if (this.hashes.contains(hash)) {
            return false;
        }
        Node<E> newNode = new Node<E>(e);
        Node<E> oldTail = this.tail.getAndSet(newNode);
        if (oldTail == null) {
            this.head.set(newNode);
        } else {
            oldTail.next = newNode;
            newNode.prev = oldTail;
        }
        this.hashes.add(hash);
        return true;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public void addFirst(E message) {
        int hash = Objects.hashCode(message);
        if (this.hashes.contains(hash)) {
            return;
        }
        Node<E> newNode = new Node<E>(message);
        Node<E> oldHead = this.head.getAndSet(newNode);
        if (oldHead == null) {
            this.tail.set(newNode);
        } else {
            oldHead.prev = newNode;
            newNode.next = oldHead;
        }
        this.hashes.add(hash);
    }

    @Override
    public E removeLast() {
        return this.remove();
    }

    @Override
    public boolean remove(Object o) {
        int hash = Objects.hashCode(o);
        if (!this.hashes.contains(hash)) {
            return false;
        }
        Node<E> node = this.head.get();
        while (node != null) {
            if (node.item.equals(o)) {
                this.removeNode(node, hash);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Set hashCodes = collection.stream().map(Objects::hashCode).collect(Collectors.toUnmodifiableSet());
        Node<E> node = this.head.get();
        while (node != null) {
            int hash = Objects.hashCode(node.item);
            if (hashCodes.contains(hash)) {
                this.removeNode(node, hash);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public E poll() {
        return this.remove();
    }

    @Override
    public E pollLast() {
        return this.remove();
    }

    @Override
    public E remove() {
        Node<E> tailItem = this.tail.get();
        if (tailItem == null) {
            return null;
        }
        Node node = this.tail.getAndSet(tailItem.prev);
        if (node == this.head.get()) {
            this.head.compareAndSet(node, tailItem.prev);
        }
        this.hashes.remove(Objects.hashCode(node.item));
        return node.item;
    }

    private void removeNode(Node<E> node, int hash) {
        if (node == this.head.get()) {
            Node removed = this.head.getAndSet(this.head.get().next);
            if (removed == this.tail.get()) {
                this.tail.compareAndSet(removed, removed.prev);
            }
        } else if (node == this.tail.get()) {
            Node removed = this.tail.getAndSet(this.tail.get().prev);
            if (removed == this.head.get()) {
                this.head.compareAndSet(removed, this.tail.get().prev);
            }
        } else {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        this.hashes.remove(hash);
    }

    @Override
    public E pollFirst() {
        return this.removeFirst();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E removeFirst() {
        Node node = this.head.getAndSet(this.head.get().next);
        if (node == this.tail.get()) {
            this.tail.compareAndSet(node, node.prev);
        }
        return node.item;
    }

    @Override
    public int size() {
        return this.hashes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.head.get() == null;
    }

    @Override
    public boolean contains(Object o) {
        return this.hashes.contains(Objects.hashCode(o));
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Node<E> nextNode;
            {
                this.nextNode = ConcurrentLinkedHashedDequeue.this.head.get();
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            @Override
            public E next() {
                if (this.nextNode == null) {
                    throw new NoSuchElementException();
                }
                Object item = this.nextNode.item;
                this.nextNode = this.nextNode.next;
                return item;
            }
        };
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Iterator<E>(){
            private Node<E> previousNode;
            {
                this.previousNode = ConcurrentLinkedHashedDequeue.this.tail.get();
            }

            @Override
            public boolean hasNext() {
                return this.previousNode != null;
            }

            @Override
            public E next() {
                if (this.previousNode == null) {
                    throw new NoSuchElementException();
                }
                Object item = this.previousNode.item;
                this.previousNode = this.previousNode.prev;
                return item;
            }
        };
    }

    @Override
    public E element() {
        return this.peek();
    }

    @Override
    public E peekFirst() {
        return this.peek();
    }

    @Override
    public E peek() {
        Node<E> headItem = this.head.get();
        if (headItem == null) {
            return null;
        }
        return headItem.item;
    }

    @Override
    public E peekLast() {
        Node<E> tailItem = this.tail.get();
        if (tailItem == null) {
            return null;
        }
        return tailItem.item;
    }

    @Override
    public E getFirst() {
        Node<E> headItem = this.head.get();
        if (headItem == null) {
            throw new NoSuchElementException();
        }
        return headItem.item;
    }

    @Override
    public E getLast() {
        Node<E> tailItem = this.tail.get();
        if (tailItem == null) {
            throw new NoSuchElementException();
        }
        return tailItem.item;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        Node<E> node = this.head.get();
        while (node != null) {
            if (node.item.equals(o)) {
                int hash = Objects.hashCode(node.item);
                this.removeNode(node, hash);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Node<E> node = this.tail.get();
        while (node != null) {
            if (filter.test(node.item)) {
                int hash = Objects.hashCode(node.item);
                this.removeNode(node, hash);
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Node<E> node = this.tail.get();
        while (node != null) {
            if (node.item.equals(o)) {
                int hash = Objects.hashCode(node.item);
                this.removeNode(node, hash);
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    private static class Node<E> {
        final E item;
        Node<E> next;
        Node<E> prev;

        Node(E item) {
            this.item = item;
        }
    }
}

