/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;

public final class Json {
    private static final ObjectMapper json;

    public static byte[] writeValueAsBytes(Object object) {
        try {
            return json.writer().writeValueAsBytes(object);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write json", exception);
        }
    }

    public static String writeValueAsString(Object object) {
        return Json.writeValueAsString(object, false);
    }

    public static String writeValueAsString(Object object, boolean pretty) {
        try {
            ObjectWriter writer = pretty ? json.writerWithDefaultPrettyPrinter() : json.writer();
            return writer.writeValueAsString(object);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write json", exception);
        }
    }

    public static <T> T readValue(byte[] value, Class<T> clazz) {
        try {
            return (T)json.readValue(value, clazz);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read json", exception);
        }
    }

    public static <T> T readValue(byte[] value, TypeReference<T> clazz) {
        try {
            return (T)json.readValue(value, clazz);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read json", exception);
        }
    }

    public static <T> T readValue(String value, Class<T> clazz) {
        try {
            return (T)json.readValue(value, clazz);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read json", exception);
        }
    }

    public static <T> T readValue(String value, TypeReference<T> clazz) {
        try {
            return (T)json.readValue(value, clazz);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read json", exception);
        }
    }

    static {
        try {
            SimpleModule optionalModule = new SimpleModule();
            optionalModule.addDeserializer(Optional.class, (JsonDeserializer)new OptionalDeserializer());
            json = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)optionalModule).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        }
        catch (Throwable throwable) {
            System.Logger logger = System.getLogger("Json");
            logger.log(System.Logger.Level.ERROR, "An exception occurred while initializing json", throwable);
            throw new RuntimeException("Cannot initialize json", throwable);
        }
    }

    private static class OptionalDeserializer
    extends StdDeserializer<Optional<?>>
    implements ContextualDeserializer {
        private final JavaType optionalType;

        public OptionalDeserializer() {
            super(Optional.class);
            this.optionalType = null;
        }

        private OptionalDeserializer(JavaType optionalType) {
            super(Optional.class);
            this.optionalType = optionalType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
            if (property == null) {
                JavaType optionalType = context.getContextualType();
                JavaType valueType = optionalType.containedTypeOrUnknown(0);
                return new OptionalDeserializer(valueType);
            }
            JavaType optionalType = property.getType();
            JavaType valueType = optionalType.containedTypeOrUnknown(0);
            return new OptionalDeserializer(valueType);
        }

        public Optional<?> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Objects.requireNonNull(this.optionalType, "Missing context");
            TreeNode node = jsonParser.getCodec().readTree(jsonParser);
            Object value = jsonParser.getCodec().treeToValue(node, this.optionalType.getRawClass());
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(value);
        }

        public Optional<?> getNullValue(DeserializationContext context) {
            return Optional.empty();
        }
    }
}

