/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import it.auties.whatsapp.crypto.AesCbc;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.media.MediaDimensions;
import it.auties.whatsapp.model.media.MediaFile;
import it.auties.whatsapp.model.media.MediaKeys;
import it.auties.whatsapp.model.media.MediaUpload;
import it.auties.whatsapp.model.media.MutableAttachmentProvider;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Validate;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public final class Medias {
    private static final HttpClient CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.ALWAYS).build();
    private static final int PROFILE_PIC_SIZE = 640;
    private static final String DEFAULT_HOST = "mmg.whatsapp.net";
    private static final int THUMBNAIL_SIZE = 32;
    private static final String USER_AGENT = "Mozilla/5.0 (Linux; Android 13) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.5735.57 Mobile Safari/537.36";

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] getProfilePic(byte[] file) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(file);){
            byte[] byArray;
            BufferedImage inputImage = ImageIO.read(inputStream);
            Image scaledImage = inputImage.getScaledInstance(640, 640, 4);
            BufferedImage outputImage = new BufferedImage(640, 640, 1);
            Graphics2D graphics2D = outputImage.createGraphics();
            graphics2D.drawImage(scaledImage, 0, 0, null);
            graphics2D.dispose();
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)outputImage, "jpg", outputStream);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (Throwable exception) {
            return file;
        }
    }

    public static Optional<byte[]> download(URI imageUri) {
        try {
            return Optional.ofNullable(Medias.downloadAsync(imageUri).join());
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static CompletableFuture<byte[]> downloadAsync(URI imageUri) {
        return Medias.downloadAsync(imageUri, true);
    }

    private static CompletableFuture<byte[]> downloadAsync(URI imageUri, boolean userAgent) {
        try {
            if (imageUri == null) {
                return CompletableFuture.completedFuture(null);
            }
            HttpRequest.Builder request = HttpRequest.newBuilder().uri(imageUri).GET();
            if (userAgent) {
                request.header("User-Agent", USER_AGENT);
            }
            return CLIENT.sendAsync(request.build(), HttpResponse.BodyHandlers.ofByteArray()).thenCompose(response -> {
                if (response.statusCode() != 200) {
                    return userAgent ? Medias.downloadAsync(imageUri, false) : CompletableFuture.failedFuture(new IllegalArgumentException("Erroneous status code: " + response.statusCode()));
                }
                return CompletableFuture.completedFuture((byte[])response.body());
            });
        }
        catch (Throwable exception) {
            return userAgent ? Medias.downloadAsync(imageUri, false) : CompletableFuture.failedFuture(exception);
        }
    }

    public static CompletableFuture<MediaFile> upload(byte[] file, AttachmentType type, MediaConnection mediaConnection) {
        String auth = URLEncoder.encode(mediaConnection.auth(), StandardCharsets.UTF_8);
        byte[] uploadData = type.inflatable() ? BytesHelper.compress(file) : file;
        MediaFile mediaFile = Medias.prepareMediaFile(type, uploadData);
        String path = type.path().orElseThrow(() -> new UnsupportedOperationException(String.valueOf((Object)type) + " cannot be uploaded"));
        String token = Base64.getUrlEncoder().withoutPadding().encodeToString(Objects.requireNonNullElse(mediaFile.fileEncSha256(), mediaFile.fileSha256()));
        URI uri = URI.create("https://%s/%s/%s?auth=%s&token=%s".formatted(DEFAULT_HOST, path, token, auth, token));
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(Objects.requireNonNullElse(mediaFile.encryptedFile(), file))).uri(uri).header("Content-Type", "application/octet-stream").header("Accept", "application/json").header("Origin", "https://web.whatsapp.com").build();
        return CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> {
            Validate.isTrue(response.statusCode() == 200, "Invalid status code: %s", response.statusCode());
            MediaUpload upload = Json.readValue((String)response.body(), MediaUpload.class);
            return new MediaFile(mediaFile.encryptedFile(), mediaFile.fileSha256(), mediaFile.fileEncSha256(), mediaFile.mediaKey(), mediaFile.fileLength(), upload.directPath(), upload.url(), upload.handle(), mediaFile.timestamp());
        });
    }

    private static MediaFile prepareMediaFile(AttachmentType type, byte[] uploadData) {
        byte[] fileSha256 = Sha256.calculate(uploadData);
        if (type.keyName().isEmpty()) {
            return new MediaFile(null, fileSha256, null, null, uploadData.length, null, null, null, null);
        }
        MediaKeys keys = MediaKeys.random(type.keyName().orElseThrow());
        byte[] encryptedMedia = AesCbc.encrypt(keys.iv(), uploadData, keys.cipherKey());
        byte[] hmac = Medias.calculateMac(encryptedMedia, keys);
        byte[] encrypted = BytesHelper.concat(encryptedMedia, hmac);
        byte[] fileEncSha256 = Sha256.calculate(encrypted);
        return new MediaFile(encrypted, fileSha256, fileEncSha256, keys.mediaKey(), uploadData.length, null, null, null, Clock.nowSeconds());
    }

    private static byte[] calculateMac(byte[] encryptedMedia, MediaKeys keys) {
        byte[] hmacInput = BytesHelper.concat(keys.iv(), encryptedMedia);
        byte[] hmac = Hmac.calculateSha256(hmacInput, keys.macKey());
        return Arrays.copyOf(hmac, 10);
    }

    public static CompletableFuture<Optional<byte[]>> downloadAsync(MutableAttachmentProvider<?> provider) {
        try {
            String url = provider.mediaUrl().or(() -> provider.mediaDirectPath().map(Medias::createMediaUrl)).orElseThrow(() -> new NoSuchElementException("Missing url and path from media"));
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            return CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenApplyAsync(response -> Medias.handleResponse(provider, response));
        }
        catch (Throwable error) {
            return CompletableFuture.failedFuture(new RuntimeException("Cannot download media", error));
        }
    }

    public static String createMediaUrl(String directPath) {
        return "https://%s%s".formatted(DEFAULT_HOST, directPath);
    }

    private static Optional<byte[]> handleResponse(MutableAttachmentProvider<?> provider, HttpResponse<byte[]> response) {
        if (response.statusCode() == 404 || response.statusCode() == 410) {
            return Optional.empty();
        }
        byte[] body = response.body();
        byte[] sha256 = Sha256.calculate(body);
        Validate.isTrue(provider.mediaEncryptedSha256().isEmpty() || Arrays.equals(sha256, provider.mediaEncryptedSha256().get()), "Cannot decode media: Invalid sha256 signature", SecurityException.class, new Object[0]);
        byte[] encryptedMedia = Arrays.copyOf(body, body.length - 10);
        byte[] mediaMac = Arrays.copyOfRange(body, body.length - 10, body.length);
        Optional<String> keyName = provider.attachmentType().keyName();
        if (keyName.isEmpty()) {
            return Optional.of(encryptedMedia);
        }
        Optional<byte[]> mediaKey = provider.mediaKey();
        if (mediaKey.isEmpty()) {
            return Optional.of(encryptedMedia);
        }
        MediaKeys keys = MediaKeys.of(mediaKey.get(), keyName.get());
        byte[] hmac = Medias.calculateMac(encryptedMedia, keys);
        Validate.isTrue(Arrays.equals(hmac, mediaMac), "media_decryption", HmacValidationException.class, new Object[0]);
        byte[] decrypted = AesCbc.decrypt(keys.iv(), encryptedMedia, keys.cipherKey());
        return Optional.of(decrypted);
    }

    public static Optional<String> getMimeType(String name) {
        return Medias.getExtension(name).map(extension -> Path.of("bogus%s".formatted(extension), new String[0])).flatMap(Medias::getMimeType);
    }

    private static Optional<String> getExtension(String name) {
        if (name == null) {
            return Optional.empty();
        }
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(name.substring(index));
    }

    public static Optional<String> getMimeType(Path path) {
        try {
            return Optional.ofNullable(Files.probeContentType(path));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    public static Optional<String> getMimeType(byte[] media) {
        try {
            return Optional.ofNullable(URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(media)));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    public static OptionalInt getPagesCount(byte[] file, String fileType) {
        Object object;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(file);
        try {
            object = switch (fileType) {
                case "docx" -> {
                    XWPFDocument docx = new XWPFDocument((InputStream)inputStream);
                    int pages = docx.getProperties().getExtendedProperties().getUnderlyingProperties().getPages();
                    docx.close();
                    yield OptionalInt.of(pages);
                }
                case "doc" -> {
                    HWPFDocument wordDoc = new HWPFDocument((InputStream)inputStream);
                    int pages = wordDoc.getSummaryInformation().getPageCount();
                    wordDoc.close();
                    yield OptionalInt.of(pages);
                }
                case "ppt" -> {
                    HSLFSlideShow document = new HSLFSlideShow((InputStream)inputStream);
                    int slides = document.getSlides().size();
                    document.close();
                    yield OptionalInt.of(slides);
                }
                case "pptx" -> {
                    XMLSlideShow show = new XMLSlideShow((InputStream)inputStream);
                    int slides = show.getSlides().size();
                    show.close();
                    yield OptionalInt.of(slides);
                }
                default -> OptionalInt.empty();
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return OptionalInt.empty();
            }
        }
        inputStream.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getDuration(byte[] file) {
        Process process;
        Path input;
        block14: {
            input = Medias.createTempFile(file);
            process = Runtime.getRuntime().exec(new String[]{"ffprobe", "-v", "error", "-show_entries", "format=duration", "-of", "default=noprint_wrappers=1:nokey=1", input.toString()});
            if (process.waitFor() == 0) break block14;
            int n = 0;
            try {
                Files.deleteIfExists(input);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return n;
        }
        String result = new String(process.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        int n = (int)Float.parseFloat(result);
        try {
            Files.deleteIfExists(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
        catch (Throwable throwable) {
            try {
                int n2 = 0;
                return n2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    Files.deleteIfExists(input);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaDimensions getDimensions(byte[] file, boolean video) {
        try {
            if (!video) {
                BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(file));
                return new MediaDimensions(originalImage.getWidth(), originalImage.getHeight());
            }
            Path input = Medias.createTempFile(file);
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"ffprobe", "-v", "error", "-select_streams", "v", "-show_entries", "stream=width,height", "-of", "json", input.toString()});
                if (process.waitFor() != 0) {
                    MediaDimensions mediaDimensions = MediaDimensions.defaultDimensions();
                    return mediaDimensions;
                }
                String result = new String(process.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                FfprobeResult ffprobe = Json.readValue(result, FfprobeResult.class);
                if (ffprobe.streams() == null || ffprobe.streams().isEmpty()) {
                    MediaDimensions mediaDimensions = MediaDimensions.defaultDimensions();
                    return mediaDimensions;
                }
                MediaDimensions mediaDimensions = ffprobe.streams().get(0);
                return mediaDimensions;
            }
            finally {
                Files.deleteIfExists(input);
            }
        }
        catch (Exception throwable) {
            return MediaDimensions.defaultDimensions();
        }
    }

    private static Path createTempFile(byte[] data) {
        try {
            Path file = Files.createTempFile(UUID.randomUUID().toString(), "", new FileAttribute[0]);
            if (data != null) {
                Files.write(file, data, new OpenOption[0]);
            }
            return file;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot create temp file", exception);
        }
    }

    public static Optional<byte[]> getThumbnail(byte[] file, String fileType) {
        return Medias.getThumbnail(file, Format.ofDocument(fileType));
    }

    public static Optional<byte[]> getThumbnail(byte[] file, Format format) {
        return switch (format.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Optional.empty();
            case 1, 2 -> Medias.getImageThumbnail(file, format);
            case 4 -> Medias.getPdfThumbnail(file);
            case 5 -> Medias.getPresentationThumbnail(file);
            case 3 -> Medias.getVideoThumbnail(file);
        };
    }

    private static Optional<byte[]> getImageThumbnail(byte[] file, Format format) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(file));
            if (image == null) {
                return Optional.empty();
            }
            int type = image.getType() == 0 ? 2 : image.getType();
            BufferedImage resizedImage = new BufferedImage(32, 32, type);
            Graphics2D graphics = resizedImage.createGraphics();
            graphics.drawImage(image, 0, 0, 32, 32, null);
            graphics.dispose();
            graphics.setComposite(AlphaComposite.Src);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resizedImage, format.name().toLowerCase(), outputStream);
            return Optional.of(outputStream.toByteArray());
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Optional<byte[]> getVideoThumbnail(byte[] file) {
        Path output;
        Path input;
        block14: {
            input = Medias.createTempFile(file);
            output = Medias.createTempFile(null);
            Process process = Runtime.getRuntime().exec(new String[]{"ffmpeg", "-ss", "00:00:00", "-i", input.toString(), "-y", "-vf", "scale=%s:-1".formatted(32), "-vframes", "1", "-f", "image2", output.toString()});
            if (process.waitFor() == 0) break block14;
            Optional<byte[]> optional = Optional.empty();
            try {
                Files.delete(input);
                Files.delete(output);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return optional;
        }
        Optional<byte[]> optional = Optional.of(Files.readAllBytes(output));
        try {
            Files.delete(input);
            Files.delete(output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return optional;
        catch (Throwable throwable) {
            try {
                Optional<byte[]> optional2 = Optional.empty();
                return optional2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    Files.delete(input);
                    Files.delete(output);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<byte[]> getPdfThumbnail(byte[] file) {
        try (PDDocument document = PDDocument.load((byte[])file);){
            Optional<byte[]> optional;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                PDFRenderer renderer = new PDFRenderer(document);
                BufferedImage image = renderer.renderImage(0);
                BufferedImage thumb = new BufferedImage(480, 339, 1);
                Graphics2D graphics2D = thumb.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(image, 0, 0, thumb.getWidth(), thumb.getHeight(), null);
                graphics2D.dispose();
                ImageIO.write((RenderedImage)thumb, "jpg", outputStream);
                optional = Optional.of(outputStream.toByteArray());
            }
            return optional;
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<byte[]> getPresentationThumbnail(byte[] file) {
        try (XMLSlideShow ppt = new XMLSlideShow((InputStream)new ByteArrayInputStream(file));){
            ByteArrayOutputStream outputStream;
            block14: {
                Optional<byte[]> optional;
                outputStream = new ByteArrayOutputStream();
                try {
                    if (!ppt.getSlides().isEmpty()) break block14;
                    optional = Optional.empty();
                }
                catch (Throwable throwable) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                outputStream.close();
                return optional;
            }
            BufferedImage thumb = new BufferedImage(480, 339, 1);
            Graphics2D graphics2D = thumb.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            ((XSLFSlide)ppt.getSlides().get(0)).draw(graphics2D);
            ImageIO.write((RenderedImage)thumb, "jpg", outputStream);
            Optional<byte[]> optional = Optional.of(outputStream.toByteArray());
            outputStream.close();
            return optional;
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static Optional<byte[]> getAudioWaveForm(byte[] audioData) {
        try {
            float[] rawData = Medias.toFloatArray(audioData);
            int samples = 64;
            int blockSize = rawData.length / samples;
            List<Integer> filteredData = IntStream.range(0, samples).map(i -> blockSize * i).map(blockStart -> IntStream.range(0, blockSize).map(j -> (int)Math.abs(rawData[blockStart + j])).sum()).mapToObj(sum -> sum / blockSize).toList();
            double multiplier = Math.pow(Collections.max(filteredData).intValue(), -1.0);
            List<Byte> normalizedData = filteredData.stream().map(data -> (byte)Math.abs((double)(100 * data) * multiplier)).toList();
            byte[] waveform = new byte[normalizedData.size()];
            IntStream.range(0, normalizedData.size()).forEach(i -> {
                waveform[i] = (Byte)normalizedData.get(i);
            });
            return Optional.of(waveform);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static float[] toFloatArray(byte[] audioData) {
        float[] rawData = new float[audioData.length / 4];
        ByteBuffer.wrap(audioData).asFloatBuffer().get(rawData);
        return rawData;
    }

    private record FfprobeResult(List<MediaDimensions> streams) {
    }

    public static enum Format {
        UNKNOWN,
        PNG,
        JPG,
        VIDEO,
        PDF,
        PPTX;


        static Format ofDocument(String fileType) {
            Format format;
            if (fileType == null) {
                format = UNKNOWN;
            } else {
                switch (fileType.toLowerCase()) {
                    case "pdf": {
                        format = PDF;
                        break;
                    }
                    case "pptx": 
                    case "ppt": {
                        format = PPTX;
                        break;
                    }
                    default: {
                        format = UNKNOWN;
                    }
                }
            }
            return format;
        }
    }
}

