/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyAuthenticator
extends Authenticator {
    private static final Map<String, URI> credentials;

    public static void register(URI uri) {
        credentials.put("%s:%s".formatted(uri.getHost(), uri.getPort()), uri);
    }

    public static void unregister(URI uri) {
        credentials.remove("%s:%s".formatted(uri.getHost(), uri.getPort()));
    }

    public static Proxy getProxy(URI uri) {
        if (uri == null) {
            return Proxy.NO_PROXY;
        }
        String scheme = Objects.requireNonNull(uri.getScheme(), "Invalid proxy, expected a scheme: %s".formatted(uri));
        String host = Objects.requireNonNull(uri.getHost(), "Invalid proxy, expected a host: %s".formatted(uri));
        int port = ProxyAuthenticator.getProxyPort(scheme, uri.getPort()).orElseThrow(() -> new NullPointerException("Invalid proxy, expected a port: %s".formatted(uri)));
        return switch (scheme) {
            case "http", "https" -> new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            case "socks4", "socks5" -> new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
            default -> throw new IllegalStateException("Unexpected scheme: " + scheme);
        };
    }

    private static OptionalInt getProxyPort(String scheme, int port) {
        OptionalInt optionalInt;
        if (port != -1) {
            optionalInt = OptionalInt.of(port);
        } else {
            switch (scheme) {
                case "http": {
                    optionalInt = OptionalInt.of(80);
                    break;
                }
                case "https": {
                    optionalInt = OptionalInt.of(443);
                    break;
                }
                default: {
                    optionalInt = OptionalInt.empty();
                }
            }
        }
        return optionalInt;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String host = "%s:%s".formatted(this.getRequestingHost(), this.getRequestingPort());
        URI info = credentials.get(host);
        if (info == null) {
            return super.getPasswordAuthentication();
        }
        String[] userInfo = info.getUserInfo().split(":", 2);
        return new PasswordAuthentication(userInfo[0], userInfo[1].toCharArray());
    }

    static {
        System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        credentials = new ConcurrentHashMap<String, URI>();
    }
}

