package it.auties.whatsapp.controller;

import it.auties.whatsapp.controller.Keys;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class KeysSpec {
    public static byte[] encode(Keys protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var uuid = protoInputObject.uuid;
if(uuid != null) {
var uuid0 = it.auties.whatsapp.util.ProtobufUuidMixin.toValue(uuid);
if(uuid0 != null) {
outputStream.writeString(1, uuid0);
}
}
var phoneNumber = protoInputObject.phoneNumber();
if(phoneNumber != null) {
var phoneNumber0 = phoneNumber.orElse(null);
if(phoneNumber0 != null) {
var phoneNumber1 = phoneNumber0.number();
outputStream.writeUInt64(2, phoneNumber1);
}
}
outputStream.writeInt32(3, it.auties.whatsapp.api.ClientTypeSpec.encode(protoInputObject.clientType));
      if(protoInputObject.alias != null) {
       for(var aliasEntry : protoInputObject.alias) {
outputStream.writeString(4, aliasEntry);
       }
      }
outputStream.writeInt32(5, protoInputObject.registrationId);
outputStream.writeBytes(6, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.noiseKeyPair));
outputStream.writeBytes(7, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.ephemeralKeyPair));
outputStream.writeBytes(8, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.identityKeyPair));
outputStream.writeBytes(9, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.companionKeyPair));
outputStream.writeBytes(10, it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPairSpec.encode(protoInputObject.signedKeyPair));
outputStream.writeBytes(11, protoInputObject.signedKeyIndex);
outputStream.writeUInt64(12, protoInputObject.signedKeyIndexTimestamp);
      if(protoInputObject.preKeys != null) {
       for(var preKeysEntry : protoInputObject.preKeys) {
outputStream.writeBytes(13, it.auties.whatsapp.model.signal.keypair.SignalPreKeyPairSpec.encode(preKeysEntry));
       }
      }
outputStream.writeString(14, protoInputObject.phoneId);
outputStream.writeBytes(15, protoInputObject.deviceId);
outputStream.writeBytes(16, protoInputObject.identityId);
outputStream.writeBytes(17, it.auties.whatsapp.model.signal.auth.SignedDeviceIdentitySpec.encode(protoInputObject.companionIdentity));
      if(protoInputObject.senderKeys != null) {
            for(var senderKeysEntry : protoInputObject.senderKeys.entrySet()) {
                var senderKeysOutputStream = new ProtobufOutputStream();
var senderKeys = senderKeysEntry.getKey();
if(senderKeys != null) {
var senderKeys0 = senderKeys.toString();
if(senderKeys0 != null) {
senderKeysOutputStream.writeString(1, senderKeys0);
}
}
senderKeysOutputStream.writeBytes(2, it.auties.whatsapp.model.signal.sender.SenderKeyRecordSpec.encode(senderKeysEntry.getValue()));
                outputStream.writeBytes(18, senderKeysOutputStream.toByteArray());
            }
      }
      if(protoInputObject.appStateKeys != null) {
       for(var appStateKeysEntry : protoInputObject.appStateKeys) {
outputStream.writeBytes(19, it.auties.whatsapp.model.companion.CompanionSyncKeySpec.encode(appStateKeysEntry));
       }
      }
      if(protoInputObject.sessions != null) {
            for(var sessionsEntry : protoInputObject.sessions.entrySet()) {
                var sessionsOutputStream = new ProtobufOutputStream();
var sessions = sessionsEntry.getKey();
if(sessions != null) {
var sessions0 = sessions.toString();
if(sessions0 != null) {
sessionsOutputStream.writeString(1, sessions0);
}
}
sessionsOutputStream.writeBytes(2, it.auties.whatsapp.model.signal.session.SessionSpec.encode(sessionsEntry.getValue()));
                outputStream.writeBytes(20, sessionsOutputStream.toByteArray());
            }
      }
      if(protoInputObject.hashStates != null) {
       for(var hashStatesEntry : protoInputObject.hashStates) {
outputStream.writeBytes(21, it.auties.whatsapp.model.companion.CompanionPatchSpec.encode(hashStatesEntry));
       }
      }
      if(protoInputObject.groupsPreKeys != null) {
            for(var groupsPreKeysEntry : protoInputObject.groupsPreKeys.entrySet()) {
                var groupsPreKeysOutputStream = new ProtobufOutputStream();
var groupsPreKeys = groupsPreKeysEntry.getKey();
if(groupsPreKeys != null) {
var groupsPreKeys0 = groupsPreKeys.toProtobufValue();
if(groupsPreKeys0 != null) {
groupsPreKeysOutputStream.writeString(1, groupsPreKeys0);
}
}
groupsPreKeysOutputStream.writeBytes(2, it.auties.whatsapp.model.signal.sender.SenderPreKeysSpec.encode(groupsPreKeysEntry.getValue()));
                outputStream.writeBytes(22, groupsPreKeysOutputStream.toByteArray());
            }
      }
outputStream.writeBool(23, protoInputObject.registered);
outputStream.writeBool(24, protoInputObject.businessCertificate);
outputStream.writeBool(25, protoInputObject.initialAppSync);
      return outputStream.toByteArray();
    }

    public static Keys decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.UUID uuid = null;
        it.auties.whatsapp.model.mobile.PhoneNumber phoneNumber = null;
        it.auties.whatsapp.api.ClientType clientType = null;
        java.util.Collection<java.lang.String> alias = new java.util.ArrayList<java.lang.String>();
        int registrationId = 0;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair noiseKeyPair = null;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair ephemeralKeyPair = null;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair identityKeyPair = null;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair companionKeyPair = null;
        it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair signedKeyPair = null;
        byte[] signedKeyIndex = null;
        java.lang.Long signedKeyIndexTimestamp = null;
        java.util.List<it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair> preKeys = new java.util.ArrayList<it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair>();
        java.lang.String phoneId = null;
        byte[] deviceId = null;
        byte[] identityId = null;
        it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity companionIdentity = null;
        java.util.Map<it.auties.whatsapp.model.signal.sender.SenderKeyName,it.auties.whatsapp.model.signal.sender.SenderKeyRecord> senderKeys = new java.util.HashMap<it.auties.whatsapp.model.signal.sender.SenderKeyName,it.auties.whatsapp.model.signal.sender.SenderKeyRecord>();
        java.util.List<it.auties.whatsapp.model.companion.CompanionSyncKey> appStateKeys = new java.util.ArrayList<it.auties.whatsapp.model.companion.CompanionSyncKey>();
        java.util.Map<it.auties.whatsapp.model.signal.session.SessionAddress,it.auties.whatsapp.model.signal.session.Session> sessions = new java.util.HashMap<it.auties.whatsapp.model.signal.session.SessionAddress,it.auties.whatsapp.model.signal.session.Session>();
        java.util.List<it.auties.whatsapp.model.companion.CompanionPatch> hashStates = new java.util.ArrayList<it.auties.whatsapp.model.companion.CompanionPatch>();
        java.util.Map<it.auties.whatsapp.model.jid.Jid,it.auties.whatsapp.model.signal.sender.SenderPreKeys> groupsPreKeys = new java.util.HashMap<it.auties.whatsapp.model.jid.Jid,it.auties.whatsapp.model.signal.sender.SenderPreKeys>();
        boolean registered = false;
        boolean businessCertificate = false;
        boolean initialAppSync = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> uuid = it.auties.whatsapp.util.ProtobufUuidMixin.of(inputStream.readString());
                case 2 -> phoneNumber = it.auties.whatsapp.model.mobile.PhoneNumber.of(inputStream.readInt64());
                case 3 -> clientType = it.auties.whatsapp.api.ClientTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 4 -> alias.add(inputStream.readString());
                case 5 -> registrationId = inputStream.readInt32();
                case 6 -> noiseKeyPair = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 7 -> ephemeralKeyPair = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 8 -> identityKeyPair = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 9 -> companionKeyPair = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 10 -> signedKeyPair = it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPairSpec.decode(inputStream.readBytes());
                case 11 -> signedKeyIndex = inputStream.readBytes();
                case 12 -> signedKeyIndexTimestamp = inputStream.readInt64();
                case 13 -> preKeys.add(it.auties.whatsapp.model.signal.keypair.SignalPreKeyPairSpec.decode(inputStream.readBytes()));
                case 14 -> phoneId = inputStream.readString();
                case 15 -> deviceId = inputStream.readBytes();
                case 16 -> identityId = inputStream.readBytes();
                case 17 -> companionIdentity = it.auties.whatsapp.model.signal.auth.SignedDeviceIdentitySpec.decode(inputStream.readBytes());
                case 18 -> {
                        var senderKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                        it.auties.whatsapp.model.signal.sender.SenderKeyName senderKeysKey = null;
                        it.auties.whatsapp.model.signal.sender.SenderKeyRecord senderKeysValue = null;
                        while(senderKeysInputStream.readTag()) {
                            switch(senderKeysInputStream.index()) {
                                case 1 -> senderKeysKey = it.auties.whatsapp.model.signal.sender.SenderKeyName.of(senderKeysInputStream.readString());
                                case 2 -> senderKeysValue = it.auties.whatsapp.model.signal.sender.SenderKeyRecordSpec.decode(senderKeysInputStream.readBytes());
                            }
                        }
                        senderKeys.put(senderKeysKey, senderKeysValue);
                }
                case 19 -> appStateKeys.add(it.auties.whatsapp.model.companion.CompanionSyncKeySpec.decode(inputStream.readBytes()));
                case 20 -> {
                        var sessionsInputStream = new ProtobufInputStream(inputStream.readBytes());
                        it.auties.whatsapp.model.signal.session.SessionAddress sessionsKey = null;
                        it.auties.whatsapp.model.signal.session.Session sessionsValue = null;
                        while(sessionsInputStream.readTag()) {
                            switch(sessionsInputStream.index()) {
                                case 1 -> sessionsKey = it.auties.whatsapp.model.signal.session.SessionAddress.of(sessionsInputStream.readString());
                                case 2 -> sessionsValue = it.auties.whatsapp.model.signal.session.SessionSpec.decode(sessionsInputStream.readBytes());
                            }
                        }
                        sessions.put(sessionsKey, sessionsValue);
                }
                case 21 -> hashStates.add(it.auties.whatsapp.model.companion.CompanionPatchSpec.decode(inputStream.readBytes()));
                case 22 -> {
                        var groupsPreKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                        it.auties.whatsapp.model.jid.Jid groupsPreKeysKey = null;
                        it.auties.whatsapp.model.signal.sender.SenderPreKeys groupsPreKeysValue = null;
                        while(groupsPreKeysInputStream.readTag()) {
                            switch(groupsPreKeysInputStream.index()) {
                                case 1 -> groupsPreKeysKey = it.auties.whatsapp.model.jid.Jid.ofProtobuf(groupsPreKeysInputStream.readString());
                                case 2 -> groupsPreKeysValue = it.auties.whatsapp.model.signal.sender.SenderPreKeysSpec.decode(groupsPreKeysInputStream.readBytes());
                            }
                        }
                        groupsPreKeys.put(groupsPreKeysKey, groupsPreKeysValue);
                }
                case 23 -> registered = inputStream.readBool();
                case 24 -> businessCertificate = inputStream.readBool();
                case 25 -> initialAppSync = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.controller.Keys(uuid, phoneNumber, clientType, alias, registrationId, noiseKeyPair, ephemeralKeyPair, identityKeyPair, companionKeyPair, signedKeyPair, signedKeyIndex, signedKeyIndexTimestamp, preKeys, phoneId, deviceId, identityId, companionIdentity, senderKeys, appStateKeys, sessions, hashStates, groupsPreKeys, registered, businessCertificate, initialAppSync);
    }

}
