package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.LabelEditAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class LabelEditActionSpec {
    public static byte[] encode(LabelEditAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.name());
outputStream.writeInt32(2, protoInputObject.color());
outputStream.writeInt32(3, protoInputObject.id());
outputStream.writeBool(4, protoInputObject.deleted());
      return outputStream.toByteArray();
    }

    public static LabelEditAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String name = null;
        int color = 0;
        int id = 0;
        boolean deleted = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> name = inputStream.readString();
                case 2 -> color = inputStream.readInt32();
                case 3 -> id = inputStream.readInt32();
                case 4 -> deleted = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.LabelEditAction(name, color, id, deleted);
    }

}
