package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.QuickReplyAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class QuickReplyActionSpec {
    public static byte[] encode(QuickReplyAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.shortcut());
outputStream.writeString(2, protoInputObject.message());
      if(protoInputObject.keywords() != null) {
       for(var keywordsEntry : protoInputObject.keywords()) {
outputStream.writeString(3, keywordsEntry);
       }
      }
outputStream.writeInt32(4, protoInputObject.count());
outputStream.writeBool(5, protoInputObject.deleted());
      return outputStream.toByteArray();
    }

    public static QuickReplyAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String shortcut = null;
        java.lang.String message = null;
        java.util.List<java.lang.String> keywords = new java.util.ArrayList<java.lang.String>();
        int count = 0;
        boolean deleted = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> shortcut = inputStream.readString();
                case 2 -> message = inputStream.readString();
                case 3 -> keywords.add(inputStream.readString());
                case 4 -> count = inputStream.readInt32();
                case 5 -> deleted = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.QuickReplyAction(shortcut, message, keywords, count, deleted);
    }

}
