package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.StarAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class StarActionSpec {
    public static byte[] encode(StarAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.starred());
      return outputStream.toByteArray();
    }

    public static StarAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean starred = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> starred = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.StarAction(starred);
    }

}
