package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.StickerAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class StickerActionSpec {
    public static byte[] encode(StickerAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.url());
outputStream.writeBytes(2, protoInputObject.fileEncSha256());
outputStream.writeBytes(3, protoInputObject.mediaKey());
outputStream.writeString(4, protoInputObject.mimetype());
outputStream.writeUInt32(5, protoInputObject.height());
outputStream.writeUInt32(6, protoInputObject.width());
outputStream.writeString(7, protoInputObject.directPath());
outputStream.writeUInt64(8, protoInputObject.fileLength());
outputStream.writeBool(9, protoInputObject.favorite());
outputStream.writeUInt32(10, protoInputObject.deviceIdHint());
      return outputStream.toByteArray();
    }

    public static StickerAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String url = null;
        byte[] fileEncSha256 = null;
        byte[] mediaKey = null;
        java.lang.String mimetype = null;
        int height = 0;
        int width = 0;
        java.lang.String directPath = null;
        long fileLength = 0l;
        boolean favorite = false;
        java.lang.Integer deviceIdHint = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> url = inputStream.readString();
                case 2 -> fileEncSha256 = inputStream.readBytes();
                case 3 -> mediaKey = inputStream.readBytes();
                case 4 -> mimetype = inputStream.readString();
                case 5 -> height = inputStream.readInt32();
                case 6 -> width = inputStream.readInt32();
                case 7 -> directPath = inputStream.readString();
                case 8 -> fileLength = inputStream.readInt64();
                case 9 -> favorite = inputStream.readBool();
                case 10 -> deviceIdHint = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.StickerAction(url, fileEncSha256, mediaKey, mimetype, height, width, directPath, fileLength, favorite, deviceIdHint);
    }

}
