package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessVerifiedNameDetailsSpec {
    public static byte[] encode(BusinessVerifiedNameDetails protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt64(1, protoInputObject.serial());
outputStream.writeString(2, protoInputObject.issuer());
outputStream.writeString(4, protoInputObject.name());
      if(protoInputObject.localizedNames() != null) {
       for(var localizedNamesEntry : protoInputObject.localizedNames()) {
outputStream.writeBytes(8, it.auties.whatsapp.model.business.BusinessLocalizedNameSpec.encode(localizedNamesEntry));
       }
      }
outputStream.writeUInt64(10, protoInputObject.issueTimeSeconds());
      return outputStream.toByteArray();
    }

    public static BusinessVerifiedNameDetails decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long serial = 0l;
        java.lang.String issuer = null;
        java.lang.String name = null;
        java.util.List<it.auties.whatsapp.model.business.BusinessLocalizedName> localizedNames = new java.util.ArrayList<it.auties.whatsapp.model.business.BusinessLocalizedName>();
        long issueTimeSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> serial = inputStream.readInt64();
                case 2 -> issuer = inputStream.readString();
                case 4 -> name = inputStream.readString();
                case 8 -> localizedNames.add(it.auties.whatsapp.model.business.BusinessLocalizedNameSpec.decode(inputStream.readBytes()));
                case 10 -> issueTimeSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.business.BusinessVerifiedNameDetails(serial, issuer, name, localizedNames, issueTimeSeconds);
    }

}
