package it.auties.whatsapp.model.button.template.highlyStructured;

import it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredCurrency;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HighlyStructuredCurrencySpec {
    public static byte[] encode(HighlyStructuredCurrency protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.currencyCode());
outputStream.writeInt64(2, protoInputObject.amount1000());
      return outputStream.toByteArray();
    }

    public static HighlyStructuredCurrency decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String currencyCode = null;
        long amount1000 = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> currencyCode = inputStream.readString();
                case 2 -> amount1000 = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredCurrency(currencyCode, amount1000);
    }

}
