package it.auties.whatsapp.model.call;

import it.auties.whatsapp.model.call.Call;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CallSpec {
    public static byte[] encode(Call protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var chat = protoInputObject.chat();
if(chat != null) {
var chat0 = chat.toProtobufValue();
if(chat0 != null) {
outputStream.writeString(1, chat0);
}
}
var caller = protoInputObject.caller();
if(caller != null) {
var caller0 = caller.toProtobufValue();
if(caller0 != null) {
outputStream.writeString(2, caller0);
}
}
outputStream.writeString(3, protoInputObject.id());
outputStream.writeUInt64(4, protoInputObject.timestampSeconds());
outputStream.writeBool(5, protoInputObject.video());
outputStream.writeInt32(6, it.auties.whatsapp.model.call.CallStatusSpec.encode(protoInputObject.status()));
outputStream.writeBool(7, protoInputObject.offline());
      return outputStream.toByteArray();
    }

    public static Call decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid chat = null;
        it.auties.whatsapp.model.jid.Jid caller = null;
        java.lang.String id = null;
        long timestampSeconds = 0l;
        boolean video = false;
        it.auties.whatsapp.model.call.CallStatus status = null;
        boolean offline = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> chat = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> caller = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 3 -> id = inputStream.readString();
                case 4 -> timestampSeconds = inputStream.readInt64();
                case 5 -> video = inputStream.readBool();
                case 6 -> status = it.auties.whatsapp.model.call.CallStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 7 -> offline = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.call.Call(chat, caller, id, timestampSeconds, video, status, offline);
    }

}
