package it.auties.whatsapp.model.companion;

import it.auties.whatsapp.model.companion.CompanionPatch;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CompanionPatchSpec {
    public static byte[] encode(CompanionPatch protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var companion = protoInputObject.companion();
if(companion != null) {
var companion0 = companion.toProtobufValue();
if(companion0 != null) {
outputStream.writeString(1, companion0);
}
}
outputStream.writeBytes(2, it.auties.whatsapp.model.companion.CompanionHashStateSpec.encode(protoInputObject.state()));
      return outputStream.toByteArray();
    }

    public static CompanionPatch decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid companion = null;
        it.auties.whatsapp.model.companion.CompanionHashState state = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> companion = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> state = it.auties.whatsapp.model.companion.CompanionHashStateSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.companion.CompanionPatch(companion, state);
    }

}
