package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.NativeFlowInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NativeFlowInfoSpec {
    public static byte[] encode(NativeFlowInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.name());
outputStream.writeString(2, protoInputObject.parameters());
      return outputStream.toByteArray();
    }

    public static NativeFlowInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String name = null;
        java.lang.String parameters = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> name = inputStream.readString();
                case 2 -> parameters = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.NativeFlowInfo(name, parameters);
    }

}
