package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.NotificationMessageInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NotificationMessageInfoSpec {
    public static byte[] encode(NotificationMessageInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
outputStream.writeBytes(2, it.auties.whatsapp.model.message.model.MessageContainerSpec.encode(protoInputObject.message()));
outputStream.writeUInt64(3, protoInputObject.messageTimestampSeconds());
var participant = protoInputObject.participant();
var participant0 = participant.orElse(null);
if(participant0 != null) {
outputStream.writeString(4, participant0);
}
      return outputStream.toByteArray();
    }

    public static NotificationMessageInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        it.auties.whatsapp.model.message.model.MessageContainer message = null;
        long messageTimestampSeconds = 0l;
        java.util.Optional<java.lang.String> participant = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> message = it.auties.whatsapp.model.message.model.MessageContainerSpec.decode(inputStream.readBytes());
                case 3 -> messageTimestampSeconds = inputStream.readInt64();
                case 4 -> participant = java.util.Optional.ofNullable(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.NotificationMessageInfo(key, message, messageTimestampSeconds, participant);
    }

}
