package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.ProductListInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ProductListInfoSpec {
    public static byte[] encode(ProductListInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      if(protoInputObject.productSections() != null) {
       for(var productSectionsEntry : protoInputObject.productSections()) {
outputStream.writeBytes(1, it.auties.whatsapp.model.product.ProductSectionSpec.encode(productSectionsEntry));
       }
      }
outputStream.writeBytes(2, it.auties.whatsapp.model.product.ProductListHeaderImageSpec.encode(protoInputObject.headerImage()));
var seller = protoInputObject.seller();
if(seller != null) {
var seller0 = seller.toProtobufValue();
if(seller0 != null) {
outputStream.writeString(3, seller0);
}
}
      return outputStream.toByteArray();
    }

    public static ProductListInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.List<it.auties.whatsapp.model.product.ProductSection> productSections = new java.util.ArrayList<it.auties.whatsapp.model.product.ProductSection>();
        it.auties.whatsapp.model.product.ProductListHeaderImage headerImage = null;
        it.auties.whatsapp.model.jid.Jid seller = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> productSections.add(it.auties.whatsapp.model.product.ProductSectionSpec.decode(inputStream.readBytes()));
                case 2 -> headerImage = it.auties.whatsapp.model.product.ProductListHeaderImageSpec.decode(inputStream.readBytes());
                case 3 -> seller = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.ProductListInfo(productSections, headerImage, seller);
    }

}
