package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.NativeFlowResponseMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NativeFlowResponseMessageSpec {
    public static byte[] encode(NativeFlowResponseMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.name());
outputStream.writeString(2, protoInputObject.paramsJson());
outputStream.writeInt32(3, protoInputObject.version());
      return outputStream.toByteArray();
    }

    public static NativeFlowResponseMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String name = null;
        java.lang.String paramsJson = null;
        int version = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> name = inputStream.readString();
                case 2 -> paramsJson = inputStream.readString();
                case 3 -> version = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.NativeFlowResponseMessage(name, paramsJson, version);
    }

}
